local assets=
{
	Asset("ANIM", "anim/swap_cutlass.zip"),
	Asset("ANIM", "anim/cutlass.zip"),
    	Asset("ATLAS", "images/inventoryimages/jianyujian.xml"),
    	Asset("IMAGE", "images/inventoryimages/jianyujian.tex"),
}




local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_cutlass", "swap_cutlass")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end


local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function onfinished(inst)
    inst:Remove()
end

local function onattack(inst, owner, target)
end


local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local netw = inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("cutlass")
    inst.AnimState:SetBuild("cutlass")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddTag("sharp")

	inst.entity:SetPristine()
	
	
    if not TheWorld.ismastersim then
        return inst
    end



    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(68)
    inst.components.weapon:SetOnAttack(onattack)
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/jianyujian.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end


return Prefab( "common/inventory/jianyujian", fn, assets, prefabs) 
