PrefabFiles = {"armor_my", "fishbrella", "fishsword", "crabber", "aquahat", "anchor"}

Assets = 
{
	Asset("ATLAS", "images/inventoryimages/armor_my.xml"),
	Asset("ATLAS", "images/inventoryimages/fishbrella.xml"),
	Asset("ATLAS", "images/inventoryimages/fishsword.xml"),
	Asset("ATLAS", "images/inventoryimages/crabber.xml"),
	Asset("ATLAS", "images/inventoryimages/aquahat.xml"),
	Asset("ATLAS", "images/inventoryimages/anchor.xml"),
}
--local DST = GLOBAL.TheSim and GLOBAL.TheSim:GetGameID()=="DST"
--local ROG = DST or GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local TECH = GLOBAL.TECH

GLOBAL.STRINGS.NAMES.ARMOR_MY = "Fish Armor"
GLOBAL.STRINGS.RECIPE_DESC.ARMOR_MY = "Slippery armored piece of fish."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ARMOR_MY = "Slippery armored piece of fish."

GLOBAL.STRINGS.NAMES.FISHBRELLA = "Fishbrella"
GLOBAL.STRINGS.RECIPE_DESC.FISHBRELLA = "Fish against the rain."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.FISHBRELLA = "Fish against the rain."

STRINGS.NAMES.FISHSWORD = "Fish Sword"
STRINGS.RECIPE_DESC.FISHSWORD = "Fish? Sword!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FISHSWORD = "Fish? Sword!"

STRINGS.NAMES.CRABBER = "Crabber"
STRINGS.RECIPE_DESC.CRABBER = "Crab people, Crab people..."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CRABBER = "Crab people, Crab people..."

STRINGS.NAMES.AQUAHAT = "Diving Helmet"
STRINGS.RECIPE_DESC.AQUAHAT = "Ready to dive."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AQUAHAT = "I'm... I'M... I'M CYBORG!"

STRINGS.NAMES.ANCHOR = "Anchor"
STRINGS.RECIPE_DESC.ANCHOR = "'Anchor into my soul!'"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ANCHOR = "'Anchor into my soul!'"

local armor_my = GLOBAL.Recipe("armor_my", { Ingredient("seaweed", 2), Ingredient("flint", 1), Ingredient("fish_raw", 4)}, RECIPETABS.WAR, {SCIENCE = 1} )
armor_my.atlas = "images/inventoryimages/armor_my.xml"

local fishbrella = GLOBAL.Recipe("fishbrella", { Ingredient("fish_raw", 1), Ingredient("seashell", 1), Ingredient("tropical_fish", 5)}, RECIPETABS.WAR, {SCIENCE = 1} )
fishbrella.atlas = "images/inventoryimages/fishbrella.xml"

local fishsword = GLOBAL.Recipe("fishsword", { Ingredient("tropical_fish", 5), Ingredient("twigs", 2), Ingredient("rope", 2)}, RECIPETABS.WAR, {SCIENCE = 1} )
fishsword.atlas = "images/inventoryimages/fishsword.xml"

local fishsword = GLOBAL.Recipe("crabber", { Ingredient("lobster_dead", 1), Ingredient("rope", 2), Ingredient("twigs", 1)}, RECIPETABS.WAR, {SCIENCE = 0} )
fishsword.atlas = "images/inventoryimages/crabber.xml"

local fishsword = GLOBAL.Recipe("aquahat", { Ingredient("transistor", 3), Ingredient("jellyfish", 1), Ingredient("messagebottleempty", 1)}, RECIPETABS.WAR, {SCIENCE = 2} )
fishsword.atlas = "images/inventoryimages/aquahat.xml"

local fishsword = GLOBAL.Recipe("anchor", { Ingredient("cutstone", 4), Ingredient("nightmarefuel", 2), Ingredient("coral", 2)}, RECIPETABS.WAR, {SCIENCE = 2} )
fishsword.atlas = "images/inventoryimages/anchor.xml"

--    .
do
	local MISS_CHANCE = 0.5 -- .
	local inventory = GLOBAL.require "components/inventory"
	local old_ApplyDamage = inventory.ApplyDamage
	function inventory:ApplyDamage(damage,...) --  ApplyDamage
		local armor = self:GetEquippedItem(GLOBAL.EQUIPSLOTS.BODY) --    ( )
		if armor and armor.prefab=="armor_my" and math.random() < MISS_CHANCE then
			return 0 --    .
		end
		return  old_ApplyDamage(self,damage,...) -- ,  .
	end	
end

AddIngredientValues({"armor_my"},{meat=1, fish=2})
AddIngredientValues({"fishbrella"},{meat=1, fish=2})
AddIngredientValues({"fishsword"},{meat=1, fish=2})
AddIngredientValues({"crabber"},{meat=1, fish=1})

modimport "loot.lua"

--[[
local RegisterRussianName = GLOBAL.rawget(GLOBAL,"RegisterRussianName")
if RegisterRussianName then
	--,  , ,  ,  ,  ,  
	RegisterRussianName("ARMOR_MY"," ","she"," "," ",nil," ")
	STRINGS.RECIPE_DESC.ARMOR_MY = "   ." 
	--    :(
end

if ROG then
local armor_my = GLOBAL.Recipe("armor_my", { Ingredient("pigskin", 2), Ingredient("flint", 1), Ingredient("fish", 4)}, RECIPETABS.WAR, {SCIENCE = 1} )
armor_my.atlas = "images/inventoryimages/armor_my.xml"
end
if not DST and GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) then
local armor_my = GLOBAL.Recipe("armor_my", { Ingredient("pigskin", 2), Ingredient("flint", 1), Ingredient("axe", 4)}, RECIPETABS.WAR, {SCIENCE = 1} )
armor_my.atlas = "images/inventoryimages/armor_my.xml"
end
]]--