local assets=
{ 
    Asset("ANIM", "anim/anchor.zip"),
    Asset("ANIM", "anim/swap_anchor.zip"), 

    Asset("ATLAS", "images/inventoryimages/anchor.xml"),
    Asset("IMAGE", "images/inventoryimages/anchor.tex"),
}

local function onfinished(inst)
    inst:Remove()
end

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_anchor", "anchor")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local OnUnequip = function(inst, owner) 
	owner.AnimState:Hide("ARM_carry") 
	owner.AnimState:Show("ARM_normal") 
end


local function fn(colour)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    
	
	MakeInventoryPhysics(inst)
    MakeInventoryFloatable(inst, "idle_water", "idle")
	
    anim:SetBank("anchor")
    anim:SetBuild("anchor")
    anim:PlayAnimation("idle")
	
	--my input
	
	inst:AddTag("sharp")

	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(79) --99
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150)
	
	inst.components.finiteuses:SetOnFinished( inst.Remove )
	
	inst:AddComponent("inspectable")
	
	--------------------------------
	--end
	
	    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "anchor"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/anchor.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

    return inst
end

return  Prefab("common/inventory/anchor", fn, assets)