local assets=
{ 
    Asset("ANIM", "anim/aquahat.zip"),
    Asset("ANIM", "anim/aquahat_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/aquahat.xml"),
    Asset("IMAGE", "images/inventoryimages/aquahat.tex"),
}

local function onfinished(inst)
    inst:Remove()
end
local function pirate_onmountboat(inst, data)
	inst.components.farseer:AddBonus("aquahat", TUNING.MAPREVEAL_PIRATEHAT_BONUS*-0.1)
end

local function pirate_ondismountboat(inst, data)
	inst.components.farseer:RemoveBonus("aquahat")
end
local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "aquahat_swap", "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")
    print('A')
    if owner:HasTag("player") then
        print('B')
        owner.AnimState:Hide("HEAD")
        owner.AnimState:Show("HEAD_HAIR")
		if owner.components.farseer then
				local boating = false 
				if owner.components.driver and owner.components.driver:GetIsDriving() then 
					boating = true 
				end 
				
				if not boating then
					owner.components.farseer:AddBonus("aquahat", TUNING.MAPREVEAL_NO_BONUS)
				else
					owner.components.farseer:AddBonus("aquahat", TUNING.MAPREVEAL_PIRATEHAT_BONUS*-0.1)
				end

				inst:ListenForEvent("mountboat", pirate_onmountboat, owner)
				inst:ListenForEvent("dismountboat", pirate_ondismountboat, owner)
		end
    end
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAIR")
		if owner.components.farseer then
				owner.components.farseer:RemoveBonus("aquahat")

				inst:RemoveEventCallback("mountboat", pirate_onmountboat, owner)
    			inst:RemoveEventCallback("dismountboat", pirate_ondismountboat, owner)
			end
    end
end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
	anim:SetBank("aquahat")
    anim:SetBuild("aquahat")
    anim:PlayAnimation("idle")
	
    MakeInventoryPhysics(inst)
	MakeInventoryFloatable(inst, "idle_water", "idle")
	inst:AddTag("hat")
	
	inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "aquahat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aquahat.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
	----------------------++++++++++++----------------------
	inst:AddComponent("armor")
	inst.components.armor:InitCondition(TUNING.ARMOR_RUINSHAT*1, 0,9) --(uses, damage%) --ruinshat=1200, 90%
	--inst.components.finiteuses:SetOnFinished( inst.Remove )
	
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL  --Per minute: TINY=1.3, SMALL=2, MED=3.3, LARGE=6,7 
	
	--inst.components.farseer:AddBonus(TUNING.MAPREVEAL_WORNPIRATEHAT_BONUS)

	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_HUGE)
	
	--SUN--
	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
    inst.components.insulator:SetSummer()
    
	inst.components.equippable.insulated = true
	
	----------------------++++++++++++----------------------

    return inst
end

return  Prefab("common/inventory/aquahat", fn, assets)