local assets=
{ 
    --Asset("ANIM", "anim/armor_my.zip"),
    Asset("ANIM", "anim/armor_my.zip"), 

    Asset("ATLAS", "images/inventoryimages/armor_my.xml"),
    Asset("IMAGE", "images/inventoryimages/armor_my.tex"),
}

local function onfinished(inst)
    inst:Remove()
end

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "armor_my", "armor_my_folder") -- owner.AnimState:OverrideSymbol("swap_body", "зип-файл", "папка")
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	MakeInventoryFloatable(inst, "idle_water", "anim")
    
    inst.AnimState:SetBank("armor_my")
    inst.AnimState:SetBuild("armor_my")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("ruins")
	inst:AddTag("metal")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/metalarmour"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/armor_my.xml"
	
    inst:AddComponent("armor")
    --inst.components.armor:InitCondition(TUNING.ARMORRUINS*.5, .8)
    inst.components.armor:InitCondition(TUNING.ARMOR_SANITY, .6)
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	
	--if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC)then
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
	--inst.components.waterproofer.effectiveness = TUNING.WATERPROOFNESS_ABSOLUTE
	inst.no_wet_prefix = true
	
	inst:AddComponent("insulator")
	inst.components.insulator:SetSummer()
	inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
	inst.components.equippable.insulated = true
	--end
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = TUNING.HEALING_TINY
	inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
	inst.components.edible.sanityvalue = -TUNING.SANITY_HUGE*1
	inst.components.edible.foodtype = "MEAT"
	
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW) -- Days: SUPERFAST=3, FAST=6, MED=10, SLOW=15, PRESERVED=20, SUPERSLOW=40
    inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	inst:AddTag("show_spoilage")
	
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst.components.equippable.poisonblocker = true
    
    return inst
end

return Prefab( "common/inventory/armor_my", fn, assets) 
