local assets=
{ 
    Asset("ANIM", "anim/fishbrella.zip"),
    Asset("ANIM", "anim/fishbrella_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/fishbrella.xml"),
    Asset("IMAGE", "images/inventoryimages/fishbrella.tex"),
}

local function onfinished(inst)
    inst:Remove()
end

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "fishbrella_swap", "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")
    print('A')
    if owner:HasTag("player") then
        print('B')
        owner.AnimState:Hide("HEAD")
        owner.AnimState:Show("HEAD_HAIR")
    end
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAIR")
    end
end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
	anim:SetBank("fishbrella")
    anim:SetBuild("fishbrella")
    anim:PlayAnimation("idle")
	
    MakeInventoryPhysics(inst)
	MakeInventoryFloatable(inst, "idle_water", "idle")
	inst:AddTag("hat")
	
	inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "fishbrella"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/fishbrella.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
	----------------------++++++++++++----------------------
	inst:AddComponent("armor")
	inst.components.armor:InitCondition(TUNING.ARMOR_FOOTBALLHAT*0.5, 0.5) --(uses, damage%)
	
	--inst.components.equippable.dapperness = -TUNING.DAPPERNESS_TINY  --Per minute: TINY=1.3, SMALL=2, MED=3.3, LARGE=6,7 
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = TUNING.HEALING_TINY
	inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
	inst.components.edible.sanityvalue = -TUNING.SANITY_HUGE*1.2
	inst.components.edible.foodtype = "MEAT"
	--[[	
	--inst.components.finiteuses:SetOnFinished( inst.Remove )
	--]]
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_HUGE)
	
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW) -- Days: SUPERFAST=3, FAST=6, MED=10, SLOW=15, PRESERVED=20, SUPERSLOW=40
    inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	inst:AddTag("show_spoilage")
	
	--SUN--
	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
    inst.components.insulator:SetSummer()
    
	inst.components.equippable.insulated = true
	
	----------------------++++++++++++----------------------

    return inst
end

return  Prefab("common/inventory/fishbrella", fn, assets)