local assets=
{ 
    Asset("ANIM", "anim/fishsword.zip"),
    Asset("ANIM", "anim/swap_fishsword.zip"), 

    Asset("ATLAS", "images/inventoryimages/fishsword.xml"),
    Asset("IMAGE", "images/inventoryimages/fishsword.tex"),
}

local function onfinished(inst)
    inst:Remove()
end

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_fishsword", "fishsword")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local OnUnequip = function(inst, owner) 
	owner.AnimState:Hide("ARM_carry") 
	owner.AnimState:Show("ARM_normal") 
end


local function fn(colour)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    
	
	MakeInventoryPhysics(inst)
    MakeInventoryFloatable(inst, "idle_water", "idle")
    anim:SetBank("fishsword")
    anim:SetBuild("fishsword")
    anim:PlayAnimation("idle")
	
	--my input
	
	inst:AddTag("sharp")

	
	
	
	
	
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(50)
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
	
	inst.components.finiteuses:SetOnFinished( inst.Remove )
	
	inst:AddComponent("inspectable")
	
	--------------------------------
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = TUNING.HEALING_TINY
	inst.components.edible.hungervalue = TUNING.CALORIES_SMALL
	inst.components.edible.sanityvalue = -TUNING.SANITY_HUGE*1.6
	inst.components.edible.foodtype = "MEAT"
	
	inst:AddTag("show_spoilage")
	--inst:AddTag("frozen")

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW) -- Days: SUPERFAST=3, FAST=6, MED=10, SLOW=15, PRESERVED=20, SUPERSLOW=40
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	
	--end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "fishsword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/fishsword.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

    return inst
end

return  Prefab("common/inventory/fishsword", fn, assets)