/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab;

import com.wuest.prefab.Config.HouseConfiguration;
import com.wuest.prefab.Config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BuildingMethods {
    public static void ClearSpace(World world, BlockPos startingPosition, int width, int height, int depth, EnumFacing houseFacing) {
        BlockPos northSide = startingPosition.func_177967_a(houseFacing, 5).func_177967_a(houseFacing.func_176746_e(), 5);
        int clearedWidth = width + 12;
        int wallLength = depth + 12;
        for (int i = 0; i < clearedWidth; ++i) {
            BuildingMethods.CreateWall(world, height, wallLength, houseFacing.func_176734_d(), northSide, Blocks.field_150350_a);
            northSide = northSide.func_177972_a(houseFacing.func_176735_f());
        }
    }

    public static void ClearSpaceExact(World world, BlockPos startingPosition, int width, int height, int depth, EnumFacing houseFacing) {
        BlockPos northSide = startingPosition;
        for (int i = 0; i < width; ++i) {
            BuildingMethods.CreateWall(world, height, depth, houseFacing.func_176734_d(), northSide, Blocks.field_150350_a);
            northSide = northSide.func_177972_a(houseFacing.func_176735_f());
        }
    }

    public static ArrayList<ItemStack> ConsolidateDrops(Block block, World world, BlockPos pos, IBlockState state, ArrayList<ItemStack> originalStacks) {
        for (ItemStack stack : block.getDrops((IBlockAccess)world, pos, state, 1)) {
            Boolean foundStack = false;
            for (ItemStack existingStack : originalStacks) {
                if (!ItemStack.func_179545_c((ItemStack)existingStack, (ItemStack)stack) || existingStack.field_77994_a + stack.field_77994_a > stack.func_77976_d()) continue;
                existingStack.field_77994_a += stack.field_77994_a;
                foundStack = true;
                break;
            }
            if (foundStack.booleanValue()) continue;
            originalStacks.add(stack);
        }
        return originalStacks;
    }

    public static ArrayList<ItemStack> CreateWall(World world, int height, int length, EnumFacing direction, BlockPos startingPosition, Block replacementBlock) {
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>();
        BlockPos wallPos = null;
        for (int i = 0; i < height; ++i) {
            wallPos = startingPosition.func_177981_b(i);
            for (int j = 0; j < length; ++j) {
                for (ItemStack stack : world.func_180495_p(wallPos).func_177230_c().getDrops((IBlockAccess)world, wallPos, world.func_180495_p(wallPos), 1)) {
                    itemsDropped.add(stack);
                }
                BuildingMethods.ReplaceBlock(world, wallPos, replacementBlock);
                wallPos = wallPos.func_177972_a(direction);
            }
        }
        return itemsDropped;
    }

    public static ArrayList<ItemStack> CreateWall(World world, int height, int length, EnumFacing direction, BlockPos startingPosition, IBlockState replacementBlock) {
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>();
        BlockPos wallPos = null;
        for (int i = 0; i < height; ++i) {
            wallPos = startingPosition.func_177981_b(i);
            for (int j = 0; j < length; ++j) {
                for (ItemStack stack : world.func_180495_p(wallPos).func_177230_c().getDrops((IBlockAccess)world, wallPos, world.func_180495_p(wallPos), 1)) {
                    itemsDropped.add(stack);
                }
                BuildingMethods.ReplaceBlock(world, wallPos, replacementBlock);
                wallPos = wallPos.func_177972_a(direction);
            }
        }
        return itemsDropped;
    }

    public static ArrayList<ItemStack> SetFloor(World world, BlockPos pos, Block block, int width, int depth, ArrayList<ItemStack> originalStack, EnumFacing facing) {
        for (int i = 0; i < width; ++i) {
            originalStack.addAll(BuildingMethods.CreateWall(world, 1, depth, facing, pos, block));
            pos = pos.func_177972_a(facing.func_176746_e());
        }
        return originalStack;
    }

    public static void SetCeiling(World world, BlockPos pos, Block block, int width, int depth, Block stairs, HouseConfiguration configuration, EnumFacing houseFacing) {
        if (configuration.isCeilingFlat) {
            BuildingMethods.SetFloor(world, pos, block, width, depth, new ArrayList<ItemStack>(), houseFacing.func_176734_d());
            return;
        }
        IBlockState stateWithoutFacing = stairs.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        int wallWidth = configuration.houseWidth;
        int wallDepth = configuration.houseDepth;
        int height = wallWidth / 2;
        boolean isWider = false;
        if (wallWidth > wallDepth) {
            height = wallDepth / 2;
            isWider = true;
        }
        for (int i = 0; i <= height; ++i) {
            for (int j = 0; j < 4; ++j) {
                EnumFacing facing = houseFacing.func_176735_f();
                EnumFacing flowDirection = houseFacing.func_176734_d();
                int wallSize = wallDepth;
                switch (j) {
                    case 1: {
                        facing = houseFacing;
                        flowDirection = houseFacing.func_176735_f();
                        wallSize = wallWidth;
                        break;
                    }
                    case 2: {
                        facing = houseFacing.func_176746_e();
                        flowDirection = houseFacing;
                        wallSize = wallDepth;
                        break;
                    }
                    case 3: {
                        facing = houseFacing.func_176734_d();
                        flowDirection = houseFacing.func_176746_e();
                        wallSize = wallWidth;
                    }
                }
                for (int k = 0; k <= wallSize; ++k) {
                    BuildingMethods.ReplaceBlock(world, pos, stateWithoutFacing.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing));
                    pos = pos.func_177972_a(flowDirection);
                }
            }
            pos = pos.func_177972_a(houseFacing.func_176735_f()).func_177972_a(houseFacing.func_176734_d()).func_177984_a();
            wallWidth -= 2;
            wallDepth -= 2;
        }
        if (world.func_175623_d(pos.func_177977_b())) {
            int finalStoneCount = wallDepth;
            if (isWider) {
                finalStoneCount = wallWidth;
            }
            finalStoneCount = finalStoneCount < 1 ? 1 : (finalStoneCount += 2);
            BlockPos torchPos = pos;
            for (int i = 0; i < finalStoneCount; ++i) {
                BuildingMethods.ReplaceBlock(world, pos, block);
                pos = isWider ? pos.func_177972_a(houseFacing.func_176735_f()) : pos.func_177972_a(houseFacing.func_176734_d());
            }
            IBlockState torchLocation = world.func_180495_p(torchPos);
            if (torchLocation.func_177230_c().canPlaceTorchOnTop(torchLocation, (IBlockAccess)world, torchPos)) {
                IBlockState blockState = ((BlockTorch)Blocks.field_150478_aa).func_176203_a(5);
                BuildingMethods.ReplaceBlock(world, torchPos.func_177984_a(), blockState);
            }
        }
    }

    public static void ReplaceBlock(World world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlock.func_176223_P(), 3);
    }

    public static void ReplaceBlockNoAir(World world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlockNoAir(world, pos, replacementBlock.func_176223_P(), 3);
    }

    public static void ReplaceBlock(World world, BlockPos pos, IBlockState replacementBlockState) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlockState, 3);
    }

    public static void ReplaceBlockNoAir(World world, BlockPos pos, IBlockState replacementBlockState) {
        BuildingMethods.ReplaceBlockNoAir(world, pos, replacementBlockState, 3);
    }

    public static void ReplaceBlock(World world, BlockPos pos, IBlockState replacementBlockState, int flags) {
        world.func_175698_g(pos);
        world.func_180501_a(pos, replacementBlockState, flags);
    }

    public static void ReplaceBlockNoAir(World world, BlockPos pos, IBlockState replacementBlockState, int flags) {
        world.func_180501_a(pos, replacementBlockState, flags);
    }

    public static int GetTorchFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 4;
            }
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 2;
            }
        }
        return 5;
    }

    public static boolean CheckBuildSpaceForAllowedBlockReplacement(StructureConfiguration configuration, World world, BlockPos startBlockPos, BlockPos endBlockPos, EntityPlayer player) {
        for (BlockPos currentPos : BlockPos.func_177980_a((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
            BlockEvent.BreakEvent breakEvent;
            IBlockState blockState = world.func_180495_p(currentPos);
            if (!blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, currentPos) && MinecraftForge.EVENT_BUS.post((Event)(breakEvent = new BlockEvent.BreakEvent(world, currentPos, world.func_180495_p(currentPos), player)))) {
                return false;
            }
            BlockEvent.PlaceEvent placeEvent = new BlockEvent.PlaceEvent(new BlockSnapshot(world, currentPos, blockState), Blocks.field_150350_a.func_176223_P(), player);
            if (!MinecraftForge.EVENT_BUS.post((Event)placeEvent)) continue;
            return false;
        }
        return true;
    }
}

