/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Config;

import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.Config.StructureConfiguration;
import com.wuest.prefab.Gui.GuiLangKeys;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class HouseConfiguration
extends StructureConfiguration {
    public static String tagKey = "WuestHouseConfig";
    private static String addTorchesTag = "addTorches";
    private static String addBedTag = "addBed";
    private static String addCraftingTableTag = "addCraftingTable";
    private static String addChestTag = "addChest";
    private static String addChestContentsTag = "addChestContents";
    private static String addFarmTag = "addFarm";
    private static String floorBlockTag = "floorBlock";
    private static String ceilingBlockTag = "ceilingBlock";
    private static String wallWoodTypeTag = "wallWoodType";
    private static String isCeilingFlatTag = "isCeilingFlat";
    private static String addMineShaftTag = "addMineShaft";
    private static String hitXTag = "hitX";
    private static String hitYTag = "hitY";
    private static String hitZTag = "hitZ";
    private static String houseWidthTag = "houseWidth";
    private static String houseDepthTag = "houseDepth";
    private static String houseFacingTag = "houseFacing";
    private static String houseStyleTag = "houseStyle";
    private static String glassColorTag = "glassColor";
    public boolean addTorches;
    public boolean addBed;
    public boolean addCraftingTable;
    public boolean addChest;
    public boolean addChestContents;
    public boolean addFarm;
    public ModConfiguration.CeilingFloorBlockType floorBlock;
    public ModConfiguration.CeilingFloorBlockType ceilingBlock;
    public ModConfiguration.WallBlockType wallWoodType;
    public boolean isCeilingFlat;
    public boolean addMineShaft;
    public HouseStyle houseStyle;
    public EnumDyeColor glassColor;
    public int houseWidth;
    public int houseDepth;

    @Override
    public void Initialize() {
        super.Initialize();
    }

    @Override
    public NBTTagCompound WriteToNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a(addTorchesTag, this.addTorches);
        tag.func_74757_a(addBedTag, this.addBed);
        tag.func_74757_a(addCraftingTableTag, this.addCraftingTable);
        tag.func_74757_a(addChestTag, this.addChest);
        tag.func_74757_a(addChestContentsTag, this.addChestContents);
        tag.func_74757_a(addFarmTag, this.addFarm);
        tag.func_74768_a(floorBlockTag, this.floorBlock.getValue());
        tag.func_74768_a(ceilingBlockTag, this.ceilingBlock.getValue());
        tag.func_74768_a(wallWoodTypeTag, this.wallWoodType.getValue());
        tag.func_74757_a(isCeilingFlatTag, this.isCeilingFlat);
        tag.func_74757_a(addMineShaftTag, this.addMineShaft);
        tag.func_74768_a(hitXTag, this.pos.func_177958_n());
        tag.func_74768_a(hitYTag, this.pos.func_177956_o());
        tag.func_74768_a(hitZTag, this.pos.func_177952_p());
        tag.func_74768_a(houseDepthTag, this.houseDepth);
        tag.func_74768_a(houseWidthTag, this.houseWidth);
        tag.func_74778_a(houseFacingTag, this.houseFacing.func_176610_l());
        tag.func_74768_a(houseStyleTag, this.houseStyle.value);
        tag.func_74778_a(glassColorTag, this.glassColor.func_176610_l().toUpperCase());
        return tag;
    }

    public static String GetIntegerOptionStringValue(String name, int value) {
        if (name.equals("prefab.gui.starter.ceilingtype") || name.equals("prefab.gui.starter.floorstone")) {
            return " - " + ModConfiguration.CeilingFloorBlockType.ValueOf(value).getName();
        }
        if (name.equals("prefab.gui.starter.walltype")) {
            return " - " + ModConfiguration.WallBlockType.ValueOf(value).getName();
        }
        return "";
    }

    public HouseConfiguration ReadFromNBTTagCompound(NBTTagCompound tag) {
        HouseConfiguration config = null;
        if (tag != null) {
            config = new HouseConfiguration();
            if (tag.func_74764_b(addTorchesTag)) {
                config.addTorches = tag.func_74767_n(addTorchesTag);
            }
            if (tag.func_74764_b(addBedTag)) {
                config.addBed = tag.func_74767_n(addBedTag);
            }
            if (tag.func_74764_b(addCraftingTableTag)) {
                config.addCraftingTable = tag.func_74767_n(addCraftingTableTag);
            }
            if (tag.func_74764_b(addChestTag)) {
                config.addChest = tag.func_74767_n(addChestTag);
            }
            if (tag.func_74764_b(addChestContentsTag)) {
                config.addChestContents = tag.func_74767_n(addChestContentsTag);
            }
            if (tag.func_74764_b(addFarmTag)) {
                config.addFarm = tag.func_74767_n(addFarmTag);
            }
            if (tag.func_74764_b(floorBlockTag)) {
                config.floorBlock = ModConfiguration.CeilingFloorBlockType.ValueOf(tag.func_74762_e(floorBlockTag));
            }
            if (tag.func_74764_b(ceilingBlockTag)) {
                config.ceilingBlock = ModConfiguration.CeilingFloorBlockType.ValueOf(tag.func_74762_e(ceilingBlockTag));
            }
            if (tag.func_74764_b(wallWoodTypeTag)) {
                config.wallWoodType = ModConfiguration.WallBlockType.ValueOf(tag.func_74762_e(wallWoodTypeTag));
            }
            if (tag.func_74764_b(isCeilingFlatTag)) {
                config.isCeilingFlat = tag.func_74767_n(isCeilingFlatTag);
            }
            if (tag.func_74764_b(addMineShaftTag)) {
                config.addMineShaft = tag.func_74767_n(addMineShaftTag);
            }
            if (tag.func_74764_b(hitXTag)) {
                config.pos = new BlockPos(tag.func_74762_e(hitXTag), tag.func_74762_e(hitYTag), tag.func_74762_e(hitZTag));
            }
            if (tag.func_74764_b(houseDepthTag)) {
                config.houseDepth = tag.func_74762_e(houseDepthTag);
            }
            if (tag.func_74764_b(houseWidthTag)) {
                config.houseWidth = tag.func_74762_e(houseWidthTag);
            }
            if (tag.func_74764_b(houseFacingTag)) {
                config.houseFacing = EnumFacing.func_176739_a((String)tag.func_74779_i(houseFacingTag));
            }
            if (tag.func_74764_b(houseStyleTag)) {
                config.houseStyle = HouseStyle.ValueOf(tag.func_74762_e(houseStyleTag));
            }
            if (tag.func_74764_b(glassColorTag)) {
                config.glassColor = EnumDyeColor.valueOf((String)tag.func_74779_i(glassColorTag));
            }
        }
        return config;
    }

    public static enum HouseStyle {
        BASIC(0, "prefab.gui.starter.basic.display", new ResourceLocation("prefab", "textures/gui/basicHouse.png"), "prefab.gui.starter.basic.notes", 153, 148, ""),
        RANCH(1, "prefab.gui.starter.ranch.display", new ResourceLocation("prefab", "textures/gui/ranchHouse.png"), "prefab.gui.starter.ranch.notes", 152, 89, "assets/prefab/structures/ranch_house.zip"),
        LOFT(2, "prefab.gui.starter.loft.display", new ResourceLocation("prefab", "textures/gui/loftHouse.png"), "prefab.gui.starter.loft.notes", 152, 87, "assets/prefab/structures/loft_house.zip"),
        HOBBIT(3, "prefab.gui.starter.hobbit.display", new ResourceLocation("prefab", "textures/gui/hobbitHouse.png"), "prefab.gui.starter.hobbit.notes", 151, 133, "assets/prefab/structures/hobbit_house.zip");

        private final int value;
        private final String displayName;
        private final ResourceLocation housePicture;
        private final String houseNotes;
        private final int imageWidth;
        private final int imageHeight;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, ResourceLocation housePicture, String houseNotes, int imageWidth, int imageHeight, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.houseNotes = houseNotes;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.structureLocation = structureLocation;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public String getHouseNotes() {
            return GuiLangKeys.translateString(this.houseNotes);
        }

        public ResourceLocation getHousePicture() {
            return this.housePicture;
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            switch (value) {
                case 0: {
                    return BASIC;
                }
                case 1: {
                    return RANCH;
                }
                case 2: {
                    return LOFT;
                }
                case 3: {
                    return HOBBIT;
                }
            }
            return BASIC;
        }
    }
}

