/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui;

import com.wuest.prefab.Config.HouseConfiguration;
import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.Prefab;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.IConfigElement;

public class GuiPrefab
extends GuiConfig {
    public GuiPrefab(GuiScreen parent) {
        super(parent, new ConfigElement(Prefab.config.getCategory(ModConfiguration.OPTIONS)).getChildElements(), "prefab", null, false, false, GuiConfig.getAbridgedConfigPath((String)Prefab.config.toString()), null);
        ConfigCategory category = Prefab.config.getCategory(ModConfiguration.OPTIONS);
        String abridgedConfigPath = GuiConfig.getAbridgedConfigPath((String)Prefab.config.toString());
        this.ReplaceIntegerEntries();
    }

    public void func_73866_w_() {
        if (this.entryList == null || this.needsRefresh) {
            this.entryList = new GuiConfigEntries((GuiConfig)this, this.field_146297_k);
            this.needsRefresh = false;
            this.ReplaceIntegerEntries();
        }
        super.func_73866_w_();
    }

    private void ReplaceIntegerEntries() {
        for (int i = 0; i < this.entryList.listEntries.size(); ++i) {
            GuiConfigEntries.IConfigEntry entry = (GuiConfigEntries.IConfigEntry)this.entryList.listEntries.get(i);
            IConfigElement element = entry.getConfigElement();
            if (element.getType() != ConfigGuiType.INTEGER) continue;
            TextNumberSliderEntry slider = new TextNumberSliderEntry(this, this.entryList, element);
            slider.updateValueButtonText();
            this.entryList.listEntries.set(i, slider);
            this.initEntries.set(i, slider);
        }
    }

    public class GuiTextSlider
    extends GuiSlider {
        TextNumberSliderEntry parentEntry;

        public GuiTextSlider(int id, int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr) {
            super(id, xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, null);
            this.parentEntry = null;
        }

        public void updateSlider() {
            String val;
            if (this.sliderValue < 0.0) {
                this.sliderValue = 0.0;
            }
            if (this.sliderValue > 1.0) {
                this.sliderValue = 1.0;
            }
            if (this.showDecimal) {
                val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
                if (val.substring(val.indexOf(".") + 1).length() > this.precision) {
                    if ((val = val.substring(0, val.indexOf(".") + this.precision + 1)).endsWith(".")) {
                        val = val.substring(0, val.indexOf(".") + this.precision);
                    }
                } else {
                    while (val.substring(val.indexOf(".") + 1).length() < this.precision) {
                        val = val + "0";
                    }
                }
            } else {
                val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
            }
            if (this.drawString) {
                if (this.parentEntry != null) {
                    this.SetSuffix();
                }
                this.field_146126_j = this.dispString + val + this.suffix;
            }
            if (this.parent != null) {
                this.parent.onChangeSliderValue((GuiSlider)this);
            }
        }

        public void SetSuffix() {
            IConfigElement configElement = this.parentEntry.getConfigElement();
            if (configElement.getType() == ConfigGuiType.INTEGER) {
                int currentValue = this.getValueInt();
                this.suffix = HouseConfiguration.GetIntegerOptionStringValue(configElement.getName(), currentValue);
            }
        }
    }

    public class TextNumberSliderEntry
    extends GuiConfigEntries.ButtonEntry {
        protected final double beforeValue;

        public TextNumberSliderEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement, (GuiButtonExt)new GuiTextSlider(0, owningEntryList.controlX, 0, owningEntryList.controlWidth, 18, "", "", Double.valueOf(configElement.getMinValue().toString()), Double.valueOf(configElement.getMaxValue().toString()), Double.valueOf(configElement.get().toString()), configElement.getType() == ConfigGuiType.DOUBLE, true));
            ((GuiTextSlider)this.btnValue).parentEntry = this;
            this.beforeValue = configElement.getType() == ConfigGuiType.INTEGER ? (double)Integer.valueOf(configElement.get().toString()).intValue() : Double.valueOf(configElement.get().toString());
        }

        public Object getCurrentValue() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt();
            }
            return ((GuiSlider)this.btnValue).getValue();
        }

        public void updateValueButtonText() {
            ((GuiSlider)this.btnValue).updateSlider();
        }

        public void valueButtonPressed(int slotIndex) {
        }

        public boolean isDefault() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt() == Integer.valueOf(this.configElement.getDefault().toString()).intValue();
            }
            return ((GuiSlider)this.btnValue).getValue() == Double.valueOf(this.configElement.getDefault().toString()).doubleValue();
        }

        public void setToDefault() {
            if (this.enabled()) {
                ((GuiSlider)this.btnValue).setValue(Double.valueOf(this.configElement.getDefault().toString()).doubleValue());
                ((GuiSlider)this.btnValue).updateSlider();
            }
        }

        public boolean isChanged() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt() != (int)Math.round(this.beforeValue);
            }
            return ((GuiSlider)this.btnValue).getValue() != this.beforeValue;
        }

        public void undoChanges() {
            if (this.enabled()) {
                ((GuiSlider)this.btnValue).setValue(this.beforeValue);
                ((GuiSlider)this.btnValue).updateSlider();
            }
        }

        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                    this.configElement.set((Object)((GuiSlider)this.btnValue).getValueInt());
                } else {
                    this.configElement.set((Object)((GuiSlider)this.btnValue).getValue());
                }
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        public Object[] getCurrentValues() {
            return new Object[]{this.getCurrentValue()};
        }
    }
}

