/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui;

import com.wuest.prefab.Config.HouseConfiguration;
import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.Controls.GuiTab;
import com.wuest.prefab.Gui.Controls.GuiTextSlider;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.ClientProxy;
import com.wuest.prefab.Proxy.Messages.HouseTagMessage;
import com.wuest.prefab.Render.StructureRenderHandler;
import com.wuest.prefab.StructureGen.CustomStructures.StructureAlternateStart;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiStartHouseChooser
extends GuiTabScreen {
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/defaultBackground.png");
    protected GuiButtonExt btnCancel;
    protected GuiButtonExt btnBuild;
    protected GuiTab tabGeneral;
    protected GuiTab tabConfig;
    protected GuiTab tabBlockTypes;
    protected GuiButtonExt btnHouseStyle;
    protected GuiButtonExt btnHouseFacing;
    protected GuiButtonExt btnGlassColor;
    protected GuiButtonExt btnVisualize;
    protected GuiCheckBox btnAddTorches;
    protected GuiCheckBox btnAddBed;
    protected GuiCheckBox btnAddCraftingTable;
    protected GuiCheckBox btnAddChest;
    protected GuiCheckBox btnAddChestContents;
    protected GuiCheckBox btnAddFarm;
    protected GuiCheckBox btnAddMineShaft;
    protected GuiCheckBox btnIsCeilingFlat;
    protected GuiSlider btnHouseWidth;
    protected GuiSlider btnHouseDepth;
    protected GuiTextSlider btnFloorBlock;
    protected GuiTextSlider btnCeilingBlock;
    protected GuiTextSlider btnWallWoodType;
    protected HouseConfiguration.HouseStyle houseStyle = HouseConfiguration.HouseStyle.BASIC;
    protected EnumFacing houseFacing = EnumFacing.NORTH;
    protected EnumDyeColor houseColor = EnumDyeColor.CYAN;
    public BlockPos pos;
    protected ModConfiguration serverConfiguration;

    public GuiStartHouseChooser(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        this.Tabs.trayWidth = 256;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.Initialize();
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.field_146294_l / 2 - 188;
        int grayBoxY = this.field_146295_m / 2 - 83;
        this.Tabs.trayX = grayBoxX;
        this.Tabs.trayY = grayBoxY - 21;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTextures);
        this.func_73729_b(grayBoxX, grayBoxY, 0, 0, 256, 256);
        for (GuiButton button : this.field_146292_n) {
            if (button == this.btnCancel || button == this.btnBuild) continue;
            button.field_146125_m = false;
        }
        this.btnAddTorches.field_146125_m = false;
        this.btnAddBed.field_146125_m = false;
        this.btnAddChest.field_146125_m = false;
        this.btnAddChestContents.field_146125_m = false;
        this.btnAddCraftingTable.field_146125_m = false;
        this.btnAddFarm.field_146125_m = false;
        this.btnAddMineShaft.field_146125_m = false;
        this.btnIsCeilingFlat.field_146125_m = false;
        if (this.getSelectedTab() == this.tabGeneral) {
            this.btnHouseStyle.field_146125_m = true;
            this.btnHouseFacing.field_146125_m = true;
            this.btnVisualize.field_146125_m = this.houseStyle != HouseConfiguration.HouseStyle.BASIC;
        } else if (this.getSelectedTab() == this.tabConfig) {
            this.btnAddTorches.field_146125_m = true;
            this.btnAddBed.field_146125_m = true;
            this.btnAddChest.field_146125_m = true;
            this.btnAddChestContents.field_146125_m = true;
            this.btnAddCraftingTable.field_146125_m = true;
            this.btnAddMineShaft.field_146125_m = true;
            if (this.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                this.btnAddFarm.field_146125_m = true;
                this.btnIsCeilingFlat.field_146125_m = true;
            }
        } else if (this.getSelectedTab() == this.tabBlockTypes) {
            if (this.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                this.btnFloorBlock.field_146125_m = true;
                this.btnWallWoodType.field_146125_m = true;
                this.btnCeilingBlock.field_146125_m = true;
                this.btnHouseDepth.field_146125_m = true;
                this.btnHouseWidth.field_146125_m = true;
            } else {
                this.btnGlassColor.field_146125_m = true;
            }
        }
        super.func_73863_a(x, y, f);
        int color = Color.DARK_GRAY.getRGB();
        if (this.getSelectedTab() == this.tabGeneral) {
            this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.style.label"), grayBoxX + 10, grayBoxY + 10, color);
            this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.structure.facing"), grayBoxX + 10, grayBoxY + 50, color);
            this.field_146297_k.field_71466_p.func_78279_b(this.houseStyle.getHouseNotes(), grayBoxX + 147, grayBoxY + 10, 95, color);
            this.field_146297_k.func_110434_K().func_110577_a(this.houseStyle.getHousePicture());
            GuiTabScreen.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, this.houseStyle.getImageWidth(), this.houseStyle.getImageHeight(), this.houseStyle.getImageWidth(), this.houseStyle.getImageHeight());
        } else if (this.getSelectedTab() == this.tabBlockTypes) {
            if (this.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.floortype.label"), grayBoxX + 10, grayBoxY + 10, color);
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.ceilingtype.label"), grayBoxX + 10, grayBoxY + 50, color);
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.walltype.label"), grayBoxX + 10, grayBoxY + 90, color);
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.depth.label"), grayBoxX + 147, grayBoxY + 10, color);
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.starter.width.label"), grayBoxX + 147, grayBoxY + 50, color);
            } else {
                this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.structure.glass"), grayBoxX + 10, grayBoxY + 10, color);
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.btnCancel) {
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.btnBuild) {
            HouseConfiguration houseConfiguration = new HouseConfiguration();
            houseConfiguration.pos = this.pos;
            houseConfiguration.addBed = this.btnAddBed.isChecked();
            houseConfiguration.addChest = this.btnAddChest.isChecked();
            houseConfiguration.addChestContents = this.btnAddChestContents.isChecked();
            houseConfiguration.addCraftingTable = this.btnAddCraftingTable.isChecked();
            houseConfiguration.addFarm = this.btnAddFarm.isChecked();
            houseConfiguration.addMineShaft = this.btnAddMineShaft.isChecked();
            houseConfiguration.addTorches = this.btnAddTorches.isChecked();
            houseConfiguration.isCeilingFlat = this.btnIsCeilingFlat.isChecked();
            houseConfiguration.ceilingBlock = ModConfiguration.CeilingFloorBlockType.ValueOf(this.btnCeilingBlock.getValueInt());
            houseConfiguration.floorBlock = ModConfiguration.CeilingFloorBlockType.ValueOf(this.btnFloorBlock.getValueInt());
            houseConfiguration.wallWoodType = ModConfiguration.WallBlockType.ValueOf(this.btnWallWoodType.getValueInt());
            houseConfiguration.houseDepth = this.btnHouseDepth.getValueInt();
            houseConfiguration.houseWidth = this.btnHouseWidth.getValueInt();
            houseConfiguration.houseFacing = this.houseFacing;
            houseConfiguration.houseStyle = this.houseStyle;
            houseConfiguration.glassColor = this.houseColor;
            Prefab.network.sendToServer((IMessage)new HouseTagMessage(houseConfiguration.WriteToNBTTagCompound()));
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.btnHouseStyle) {
            int id = this.houseStyle.getValue() + 1;
            this.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            if (this.houseStyle == HouseConfiguration.HouseStyle.LOFT && !this.serverConfiguration.enableLoftHouse) {
                id = this.houseStyle.getValue() + 1;
                this.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            }
            this.btnHouseStyle.field_146126_j = this.houseStyle.getDisplayName();
            if (this.houseStyle == HouseConfiguration.HouseStyle.HOBBIT) {
                this.houseColor = EnumDyeColor.GREEN;
                this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(EnumDyeColor.GREEN);
            } else if (this.houseStyle == HouseConfiguration.HouseStyle.LOFT) {
                this.houseColor = EnumDyeColor.BLACK;
                this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(EnumDyeColor.BLACK);
            } else {
                this.houseColor = EnumDyeColor.CYAN;
                this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(EnumDyeColor.CYAN);
            }
        } else if (button == this.btnHouseFacing) {
            this.houseFacing = this.houseFacing.func_176746_e();
            this.btnHouseFacing.field_146126_j = GuiLangKeys.translateFacing(this.houseFacing);
        } else if (button == this.btnGlassColor) {
            this.houseColor = EnumDyeColor.func_176764_b((int)(this.houseColor.func_176765_a() + 1));
            this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(this.houseColor);
        } else if (button == this.btnVisualize) {
            HouseConfiguration configuration = new HouseConfiguration();
            configuration.pos = this.pos;
            configuration.glassColor = this.houseColor;
            configuration.houseFacing = this.houseFacing;
            configuration.houseStyle = this.houseStyle;
            StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(configuration.houseStyle.getStructureLocation(), StructureAlternateStart.class);
            StructureRenderHandler.setStructure(structure, EnumFacing.NORTH, configuration);
            this.field_146297_k.func_147108_a(null);
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    private void Initialize() {
        int grayBoxX = this.field_146294_l / 2 - 188;
        int grayBoxY = this.field_146295_m / 2 - 83;
        int color = Color.DARK_GRAY.getRGB();
        this.serverConfiguration = ((ClientProxy)Prefab.proxy).getServerConfiguration();
        this.btnHouseStyle = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 20, 90, 20, this.houseStyle.getDisplayName());
        this.field_146292_n.add(this.btnHouseStyle);
        this.btnHouseFacing = new GuiButtonExt(3, grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateFacing(EnumFacing.NORTH));
        this.field_146292_n.add(this.btnHouseFacing);
        this.btnVisualize = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.field_146292_n.add(this.btnVisualize);
        int x = grayBoxX + 10;
        int y = grayBoxY + 10;
        this.btnAddTorches = new GuiCheckBox(1, x, y, GuiLangKeys.translateString("prefab.gui.starter.addtorches"), true);
        this.btnAddTorches.setStringColor(color);
        this.btnAddTorches.setWithShadow(false);
        this.btnAddTorches.field_146125_m = false;
        this.field_146292_n.add(this.btnAddTorches);
        this.btnAddBed = new GuiCheckBox(2, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.addbed"), true);
        this.btnAddBed.setStringColor(color);
        this.btnAddBed.setWithShadow(false);
        this.btnAddBed.field_146125_m = false;
        this.field_146292_n.add(this.btnAddBed);
        this.btnAddChest = new GuiCheckBox(3, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.addchest"), true);
        this.btnAddChest.setStringColor(color);
        this.btnAddChest.setWithShadow(false);
        this.btnAddChest.field_146125_m = false;
        this.field_146292_n.add(this.btnAddChest);
        this.btnAddChestContents = new GuiCheckBox(4, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.addchestcontents"), true);
        this.btnAddChestContents.setStringColor(color);
        this.btnAddChestContents.setWithShadow(false);
        this.btnAddChestContents.field_146125_m = false;
        this.field_146292_n.add(this.btnAddChestContents);
        this.btnAddCraftingTable = new GuiCheckBox(5, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.addcraftingtable"), true);
        this.btnAddCraftingTable.setStringColor(color);
        this.btnAddCraftingTable.setWithShadow(false);
        this.btnAddCraftingTable.field_146125_m = false;
        this.field_146292_n.add(this.btnAddCraftingTable);
        this.btnAddMineShaft = new GuiCheckBox(7, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.buildmineshaft"), true);
        this.btnAddMineShaft.setStringColor(color);
        this.btnAddMineShaft.setWithShadow(false);
        this.btnAddMineShaft.field_146125_m = false;
        this.field_146292_n.add(this.btnAddMineShaft);
        this.btnAddFarm = new GuiCheckBox(6, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.addfarm"), true);
        this.btnAddFarm.setStringColor(color);
        this.btnAddFarm.setWithShadow(false);
        this.btnAddFarm.field_146125_m = false;
        this.field_146292_n.add(this.btnAddFarm);
        this.btnIsCeilingFlat = new GuiCheckBox(8, x, y += 15, GuiLangKeys.translateString("prefab.gui.starter.ceilingflat"), false);
        this.btnIsCeilingFlat.setStringColor(color);
        this.btnIsCeilingFlat.setWithShadow(false);
        this.btnIsCeilingFlat.field_146125_m = false;
        this.field_146292_n.add(this.btnIsCeilingFlat);
        this.btnFloorBlock = new GuiTextSlider(11, grayBoxX + 10, grayBoxY + 20, 90, 20, 0.0, 2.0, 0.0, "prefab.gui.starter.floorstone");
        this.field_146292_n.add(this.btnFloorBlock);
        this.btnCeilingBlock = new GuiTextSlider(12, grayBoxX + 10, grayBoxY + 60, 90, 20, 0.0, 2.0, 0.0, "prefab.gui.starter.ceilingtype");
        this.field_146292_n.add(this.btnCeilingBlock);
        this.btnWallWoodType = new GuiTextSlider(13, grayBoxX + 10, grayBoxY + 100, 90, 20, 0.0, 5.0, 0.0, "prefab.gui.starter.walltype");
        this.field_146292_n.add(this.btnWallWoodType);
        this.btnGlassColor = new GuiButtonExt(17, grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateDye(EnumDyeColor.CYAN));
        this.field_146292_n.add(this.btnGlassColor);
        this.btnHouseDepth = new GuiSlider(15, grayBoxX + 147, grayBoxY + 20, 90, 20, "", "", 5.0, (double)this.serverConfiguration.maximumStartingHouseSize, 9.0, false, true);
        this.field_146292_n.add(this.btnHouseDepth);
        this.btnHouseWidth = new GuiSlider(16, grayBoxX + 147, grayBoxY + 60, 90, 20, "", "", 5.0, (double)this.serverConfiguration.maximumStartingHouseSize, 9.0, false, true);
        this.field_146292_n.add(this.btnHouseWidth);
        this.tabGeneral = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.general"), grayBoxX + 3, grayBoxY - 20);
        this.Tabs.AddTab(this.tabGeneral);
        this.tabConfig = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.config"), grayBoxX + 54, grayBoxY - 20);
        this.Tabs.AddTab(this.tabConfig);
        this.tabBlockTypes = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.block"), grayBoxX + 105, grayBoxY - 20);
        this.tabBlockTypes.width = 70;
        this.Tabs.AddTab(this.tabBlockTypes);
        this.btnBuild = new GuiButtonExt(1, grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(2, grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.field_146292_n.add(this.btnCancel);
    }
}

