/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Gui;

import com.wuest.prefab.Config.WareHouseConfiguration;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.Messages.WareHouseTagMessage;
import com.wuest.prefab.Render.StructureRenderHandler;
import com.wuest.prefab.StructureGen.CustomStructures.StructureWarehouse;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiWareHouse
extends GuiScreen {
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/defaultBackground.png");
    private static final ResourceLocation wareHouseTopDown = new ResourceLocation("prefab", "textures/gui/wareHouseTopDown.png");
    protected GuiButtonExt btnCancel;
    protected GuiButtonExt btnBuild;
    protected GuiButtonExt btnVisualize;
    public BlockPos pos;
    protected GuiButtonExt btnHouseFacing;
    protected GuiButtonExt btnGlassColor;
    protected WareHouseConfiguration configuration;

    public GuiWareHouse(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
    }

    public void Initialize() {
        this.configuration = new WareHouseConfiguration();
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = EnumFacing.NORTH;
        int grayBoxX = this.field_146294_l / 2 - 180;
        int grayBoxY = this.field_146295_m / 2 - 83;
        this.btnHouseFacing = new GuiButtonExt(3, grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateFacing(this.configuration.houseFacing));
        this.field_146292_n.add(this.btnHouseFacing);
        this.btnGlassColor = new GuiButtonExt(10, grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateDye(this.configuration.dyeColor));
        this.field_146292_n.add(this.btnGlassColor);
        this.btnVisualize = new GuiButtonExt(4, grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.field_146292_n.add(this.btnVisualize);
        this.btnBuild = new GuiButtonExt(1, grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.field_146292_n.add(this.btnBuild);
        this.btnCancel = new GuiButtonExt(2, grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
        this.field_146292_n.add(this.btnCancel);
    }

    public void func_73866_w_() {
        this.Initialize();
    }

    public boolean func_73868_f() {
        return true;
    }

    public void func_73863_a(int x, int y, float f) {
        int grayBoxX = this.field_146294_l / 2 - 180;
        int grayBoxY = this.field_146295_m / 2 - 83;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(wareHouseTopDown);
        GuiWareHouse.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, 0.0f, 0.0f, 132, 153, 132.0f, 153.0f);
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTextures);
        this.func_73729_b(grayBoxX, grayBoxY, 0, 0, 256, 256);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_146112_a(this.field_146297_k, x, y);
        }
        for (int j = 0; j < this.field_146293_o.size(); ++j) {
            ((GuiLabel)this.field_146293_o.get(j)).func_146159_a(this.field_146297_k, x, y);
        }
        int color = Color.DARK_GRAY.getRGB();
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.structure.facing"), grayBoxX + 10, grayBoxY + 10, color);
        this.field_146297_k.field_71466_p.func_78276_b(GuiLangKeys.translateString("prefab.gui.structure.glass"), grayBoxX + 10, grayBoxY + 50, color);
        this.field_146297_k.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), grayBoxX + 147, grayBoxY + 10, 95, color);
        this.field_146297_k.field_71466_p.func_78279_b(GuiLangKeys.translateString("prefab.gui.structure.door.facing"), grayBoxX + 147, grayBoxY + 60, 95, color);
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, int z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.btnCancel) {
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((IMessage)new WareHouseTagMessage(this.configuration.WriteToNBTTagCompound()));
            this.field_146297_k.func_147108_a(null);
        } else if (button == this.btnHouseFacing) {
            this.configuration.houseFacing = this.configuration.houseFacing.func_176746_e();
            this.btnHouseFacing.field_146126_j = GuiLangKeys.translateFacing(this.configuration.houseFacing);
        } else if (button == this.btnGlassColor) {
            this.configuration.dyeColor = EnumDyeColor.func_176764_b((int)(this.configuration.dyeColor.func_176765_a() + 1));
            this.btnGlassColor.field_146126_j = GuiLangKeys.translateDye(this.configuration.dyeColor);
        } else if (button == this.btnVisualize) {
            StructureWarehouse structure = (StructureWarehouse)StructureWarehouse.CreateInstance("assets/prefab/structures/warehouse.zip", StructureWarehouse.class);
            StructureRenderHandler.setStructure(structure, EnumFacing.NORTH, this.configuration);
            this.field_146297_k.func_147108_a(null);
        }
    }
}

