/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Render;

import com.wuest.prefab.Events.ClientEventHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;

public class ShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    public static int alphaShader = 0;

    public static void Initialize() {
        alphaShader = ShaderHelper.createProgram("/assets/prefab/shader/alpha.vert", "/assets/prefab/shader/alpha.frag");
    }

    public static void useShader(int shader) {
        if (!OpenGlHelper.field_148824_g) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            ARBShaderObjects.glUniform1iARB((int)time, (int)ClientEventHandler.ticksInGame);
            int alpha = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"alpha");
            ARBShaderObjects.glUniform1fARB((int)alpha, (float)0.4f);
        }
    }

    public static void releaseShader() {
        ShaderHelper.useShader(0);
    }

    private static int createProgram(String vert, String frag) {
        int program;
        int vertId = 0;
        int fragId = 0;
        if (vert != null) {
            vertId = ShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragId = ShaderHelper.createShader(frag, 35632);
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHelper.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String readFileAsString(String filename) throws Exception {
        InputStream in = ShaderHelper.class.getResourceAsStream(filename);
        if (in == null) {
            return "";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }
}

