/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Render;

import com.google.common.base.Throwables;
import com.wuest.prefab.Config.StructureConfiguration;
import com.wuest.prefab.Render.ShaderHelper;
import com.wuest.prefab.StructureGen.BuildBlock;
import com.wuest.prefab.StructureGen.Structure;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;

public class StructureRenderHandler {
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static EnumFacing assumedNorth;
    public static boolean rendering;
    public static boolean showedMessage;
    private static int dimension;
    private static final String[] RENDERPOSX;
    private static final String[] RENDERPOSY;
    private static final String[] RENDERPOSZ;
    private static final MethodHandle renderPosX_getter;
    private static final MethodHandle renderPosY_getter;
    private static final MethodHandle renderPosZ_getter;

    public static void setStructure(Structure structure, EnumFacing assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.field_73011_w.getDimension();
        }
    }

    public static void renderPlayerLook(EntityPlayer player, RayTraceResult src) {
        if (currentStructure != null && dimension == player.field_70170_p.field_73011_w.getDimension() && currentConfiguration != null) {
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)64);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            rendering = true;
            boolean didAny = false;
            ShaderHelper.useShader(ShaderHelper.alphaShader);
            for (BuildBlock buildBlock : currentStructure.getBlocks()) {
                IBlockState blockState;
                Block foundBlock = (Block)Block.field_149771_c.func_82594_a((Object)buildBlock.getResourceLocation());
                if (foundBlock == null || (buildBlock = BuildBlock.SetBlockState(currentConfiguration, player.field_70170_p, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock, foundBlock, blockState = foundBlock.func_176223_P())).getStartingPosition().getHeightOffset() <= 0 || !StructureRenderHandler.renderComponentInWorld(player.field_70170_p, buildBlock)) continue;
                didAny = true;
            }
            ShaderHelper.releaseShader();
            rendering = false;
            GL11.glPopAttrib();
            GlStateManager.func_179121_F();
            if (!didAny) {
                StructureRenderHandler.setStructure(null, EnumFacing.NORTH, null);
                player.func_146105_b(new TextComponentTranslation("prefab.gui.preview.complete", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            } else if (!showedMessage) {
                player.func_146105_b(new TextComponentTranslation("prefab.gui.preview.notice", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                showedMessage = true;
            }
        }
    }

    private static boolean renderComponentInWorld(World world, BuildBlock buildBlock) {
        double renderPosZ;
        double renderPosY;
        double renderPosX;
        try {
            renderPosX = renderPosX_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosY = renderPosY_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosZ = renderPosZ_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
        }
        catch (Throwable t) {
            return true;
        }
        BlockPos pos = buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, StructureRenderHandler.currentConfiguration.houseFacing);
        if (!world.func_175623_d(pos)) {
            return false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-renderPosX), (double)(-renderPosY), (double)(-renderPosZ));
        GlStateManager.func_179097_i();
        StructureRenderHandler.doRenderComponent(buildBlock, pos);
        GlStateManager.func_179121_F();
        if (buildBlock.getSubBlock() != null) {
            Block foundBlock = (Block)Block.field_149771_c.func_82594_a((Object)buildBlock.getSubBlock().getResourceLocation());
            IBlockState blockState = foundBlock.func_176223_P();
            BuildBlock subBlock = BuildBlock.SetBlockState(currentConfiguration, world, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock.getSubBlock(), foundBlock, blockState);
            return StructureRenderHandler.renderComponentInWorld(world, subBlock);
        }
        return true;
    }

    private static void doRenderComponent(BuildBlock buildBlock, BlockPos pos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        IBlockState state = buildBlock.getBlockState();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (state == null) {
            return;
        }
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 1));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        brd.func_175016_a(state, 1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    static {
        rendering = false;
        showedMessage = false;
        RENDERPOSX = new String[]{"renderPosX", "field_78725_b", "o"};
        RENDERPOSY = new String[]{"renderPosY", "field_78726_c", "p"};
        RENDERPOSZ = new String[]{"renderPosZ", "field_78723_d", "q"};
        try {
            Field f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSX);
            f.setAccessible(true);
            renderPosX_getter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSY);
            f.setAccessible(true);
            renderPosY_getter = MethodHandles.publicLookup().unreflectGetter(f);
            f = ReflectionHelper.findField(RenderManager.class, (String[])RENDERPOSZ);
            f.setAccessible(true);
            renderPosZ_getter = MethodHandles.publicLookup().unreflectGetter(f);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw Throwables.propagate((Throwable)e);
        }
    }
}

