/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.StructureGen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.wuest.prefab.BuildingMethods;
import com.wuest.prefab.Config.StructureConfiguration;
import com.wuest.prefab.Events.ModEventHandler;
import com.wuest.prefab.StructureGen.BuildBlock;
import com.wuest.prefab.StructureGen.BuildClear;
import com.wuest.prefab.StructureGen.BuildProperty;
import com.wuest.prefab.ZipUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Structure {
    @Expose
    private String name;
    @Expose
    private BuildClear clearSpace;
    @Expose
    private ArrayList<BuildBlock> blocks;
    public ArrayList<BlockPos> clearedBlockPos = new ArrayList();
    public ArrayList<BuildBlock> priorityOneBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityTwoBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityThreeBlocks = new ArrayList();
    public StructureConfiguration configuration;
    public World world;
    public BlockPos originalPos;
    public EnumFacing assumedNorth;

    public Structure() {
        this.Initialize();
    }

    public static <T extends Structure> T CreateInstance(String resourceLocation, Class<? extends Structure> child) {
        Structure structure = null;
        Gson file = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        structure = (Structure)file.fromJson(ZipUtil.decompressResource(resourceLocation), child);
        return (T)structure;
    }

    public static void CreateStructureFile(Structure structure, String fileLocation) {
        try {
            Gson converter = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            StringWriter stringWriter = new StringWriter();
            converter.toJson((Object)structure, (Appendable)stringWriter);
            ZipUtil.zipStringToFile(stringWriter.toString(), fileLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ScanStructure(World world, BlockPos originalPos, BlockPos cornerPos1, BlockPos cornerPos2, String fileLocation, BuildClear clearedSpace, EnumFacing playerFacing) {
        Structure scannedStructure = new Structure();
        scannedStructure.setClearSpace(clearedSpace);
        for (BlockPos currentPos : BlockPos.func_177980_a((BlockPos)cornerPos1, (BlockPos)cornerPos2)) {
            if (world.func_175623_d(currentPos)) continue;
            IBlockState currentState = world.func_180495_p(currentPos);
            Block currentBlock = currentState.func_177230_c();
            BuildBlock buildBlock = new BuildBlock();
            buildBlock.setBlockDomain(currentBlock.getRegistryName().func_110624_b());
            buildBlock.setBlockName(currentBlock.getRegistryName().func_110623_a());
            if (currentPos.func_177958_n() > originalPos.func_177958_n()) {
                buildBlock.getStartingPosition().setEastOffset(currentPos.func_177958_n() - originalPos.func_177958_n());
            } else {
                buildBlock.getStartingPosition().setWestOffset(originalPos.func_177958_n() - currentPos.func_177958_n());
            }
            if (currentPos.func_177952_p() > originalPos.func_177952_p()) {
                buildBlock.getStartingPosition().setSouthOffset(currentPos.func_177952_p() - originalPos.func_177952_p());
            } else {
                buildBlock.getStartingPosition().setNorthOffset(originalPos.func_177952_p() - currentPos.func_177952_p());
            }
            buildBlock.getStartingPosition().setHeightOffset(currentPos.func_177956_o() - originalPos.func_177956_o());
            ImmutableMap properties = currentState.func_177228_b();
            for (Map.Entry entry : properties.entrySet()) {
                BuildProperty property = new BuildProperty();
                property.setName(((IProperty)entry.getKey()).func_177701_a());
                if (currentBlock instanceof BlockQuartz && property.getName().equals("variant")) {
                    property.setValue(((BlockQuartz.EnumType)entry.getValue()).func_176610_l());
                } else {
                    property.setValue(((Comparable)entry.getValue()).toString());
                }
                buildBlock.getProperties().add(property);
            }
            scannedStructure.getBlocks().add(buildBlock);
        }
        Structure.CreateStructureFile(scannedStructure, fileLocation);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BuildClear getClearSpace() {
        return this.clearSpace;
    }

    public void setClearSpace(BuildClear value) {
        this.clearSpace = value;
    }

    public ArrayList<BuildBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<BuildBlock> value) {
        this.blocks = value;
    }

    public void Initialize() {
        this.name = "";
        this.clearSpace = new BuildClear();
        this.blocks = new ArrayList();
    }

    public boolean BuildStructure(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        BlockPos endBlockPos;
        BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, configuration.houseFacing);
        if (!BuildingMethods.CheckBuildSpaceForAllowedBlockReplacement(configuration, world, startBlockPos, endBlockPos = startBlockPos.func_177967_a(configuration.houseFacing.func_176735_f(), this.clearSpace.getShape().getWidth() - 1).func_177967_a(configuration.houseFacing.func_176734_d(), this.clearSpace.getShape().getWidth() - 1).func_177967_a(EnumFacing.UP, this.clearSpace.getShape().getHeight()), player)) {
            player.func_146105_b(new TextComponentTranslation("prefab.gui.structure.nobuild", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            return false;
        }
        if (!this.BeforeBuilding(configuration, world, originalPos, assumedNorth, player)) {
            this.ClearSpace(configuration, world, originalPos, assumedNorth);
            for (BuildBlock block : this.getBlocks()) {
                Block foundBlock = (Block)Block.field_149771_c.func_82594_a((Object)block.getResourceLocation());
                if (foundBlock == null) continue;
                IBlockState blockState = foundBlock.func_176223_P();
                BuildBlock subBlock = null;
                if (this.CustomBlockProcessingHandled(configuration, block, world, originalPos, assumedNorth, foundBlock, blockState, player).booleanValue()) continue;
                if ((block = BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState)).getSubBlock() != null) {
                    foundBlock = (Block)Block.field_149771_c.func_82594_a((Object)block.getSubBlock().getResourceLocation());
                    blockState = foundBlock.func_176223_P();
                    subBlock = BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block.getSubBlock(), foundBlock, blockState);
                }
                if (subBlock != null) {
                    block.setSubBlock(subBlock);
                }
                if (!block.getHasFacing()) {
                    if (subBlock != null) {
                        block.setSubBlock(subBlock);
                    }
                    this.priorityOneBlocks.add(block);
                    continue;
                }
                if (foundBlock instanceof BlockTorch || foundBlock instanceof BlockSign || foundBlock instanceof BlockLever || foundBlock instanceof BlockButton) {
                    this.priorityThreeBlocks.add(block);
                    continue;
                }
                this.priorityTwoBlocks.add(block);
            }
            if (ModEventHandler.structuresToBuild.containsKey(player)) {
                ModEventHandler.structuresToBuild.get(player).add(this);
            } else {
                ArrayList<Structure> structures = new ArrayList<Structure>();
                structures.add(this);
                this.configuration = configuration;
                this.world = world;
                this.assumedNorth = assumedNorth;
                this.originalPos = originalPos;
                ModEventHandler.structuresToBuild.put(player, structures);
            }
        }
        return true;
    }

    protected boolean BeforeBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        return false;
    }

    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
    }

    protected void ClearSpace(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth) {
        BlockPos startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, configuration.houseFacing);
        BlockPos endBlockPos = startBlockPos.func_177967_a(configuration.houseFacing.func_176735_f(), this.clearSpace.getShape().getWidth() - 1).func_177967_a(configuration.houseFacing.func_176734_d(), this.clearSpace.getShape().getLength() - 1).func_177967_a(EnumFacing.UP, this.clearSpace.getShape().getHeight());
        this.clearedBlockPos = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)startBlockPos, (BlockPos)endBlockPos));
    }

    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        return false;
    }
}

