<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Auth as lAuth;

class Auth extends Base
{

    /**
     * @api {post} /admin/auth/lists 获取所有权限节点
     * @apiGroup 角色权限
     * @apiName 获取所有权限节点接口
     *
     * @apiDescription 获取所有的权限节点
     *
     * @apiParam {String} manager_access_token  用户token
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"","data":[{"id":1,"pid":0,"title":"首页","iconfont":"","param":"","type":0,"sort":0,"remark":"","route_url":"","status":1},{"id":9,"pid":0,"title":"系统","iconfont":"","param":"","type":0,"sort":0,"remark":"","route_url":"","status":1},{"id":2,"pid":0,"title":"用户管理","iconfont":"mdi-home","param":"","type":0,"sort":1,"remark":"","route_url":"","status":1},{"id":10,"pid":2,"title":"角色权限","iconfont":"","param":"","type":0,"sort":1,"remark":"","route_url":"","status":1},{"id":3,"pid":0,"title":"游戏管理","iconfont":"","param":"","type":0,"sort":2,"remark":"","route_url":"","status":1},{"id":4,"pid":0,"title":"数据管理","iconfont":"mdi-account-group-outline","param":" ","type":0,"sort":3,"remark":" ","route_url":"","status":1},{"id":5,"pid":0,"title":"财务管理","iconfont":"mdi-account-group-outline","param":" ","type":0,"sort":4,"remark":" ","route_url":"","status":1},{"id":6,"pid":0,"title":"荣誉管理","iconfont":"mdi-av-timer","param":"","type":0,"sort":5,"remark":"","route_url":"","status":1},{"id":7,"pid":0,"title":"系统管理","iconfont":"mdi-av-timer","param":"","type":0,"sort":6,"remark":"","route_url":"","status":1},{"id":8,"pid":0,"title":"渠道对接","iconfont":"","param":"","type":0,"sort":7,"remark":"","route_url":"","status":1}]}
     *
     *
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lAuth = new lAuth();
            return json($lAuth -> lists($param));
        }
        return false;
    }


    /**
     * @api {post} /admin/auth/menu 获取用户权限
     * @apiGroup PUBLIC
     * @apiName 获取用户权限节点接口
     *
     * @apiDescription 获取当前用户角色权限节点
     *
     * @apiParam {String} manager_access_token  用户token
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"","data":[{"id":1,"pid":0,"title":"首页","iconfont":"","param":"","type":0,"sort":0,"remark":"","route_url":"","status":1},{"id":9,"pid":0,"title":"系统","iconfont":"","param":"","type":0,"sort":0,"remark":"","route_url":"","status":1},{"id":2,"pid":0,"title":"用户管理","iconfont":"mdi-home","param":"","type":0,"sort":1,"remark":"","route_url":"","status":1},{"id":3,"pid":0,"title":"游戏管理","iconfont":"","param":"","type":0,"sort":2,"remark":"","route_url":"","status":1},{"id":4,"pid":0,"title":"数据管理","iconfont":"mdi-account-group-outline","param":" ","type":0,"sort":3,"remark":" ","route_url":"","status":1},{"id":5,"pid":0,"title":"财务管理","iconfont":"mdi-account-group-outline","param":" ","type":0,"sort":4,"remark":" ","route_url":"","status":1},{"id":6,"pid":0,"title":"荣誉管理","iconfont":"mdi-av-timer","param":"","type":0,"sort":5,"remark":"","route_url":"","status":1},{"id":7,"pid":0,"title":"系统管理","iconfont":"mdi-av-timer","param":"","type":0,"sort":6,"remark":"","route_url":"","status":1},{"id":8,"pid":0,"title":"渠道对接","iconfont":"","param":"","type":0,"sort":7,"remark":"","route_url":"","status":1}]}
     *
     *
     */
    public function menu()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lAuth = new lAuth();
            return json($lAuth -> menu($param));
        }
        return false;
    }

}
