<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Honor as lHonor;

class Honor extends Base
{

    /**
     * @荣誉列表
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/6/1 15:52
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonor = new lHonor();
            return json($lHonor -> lists($param));
        }
    }

    /**
     * @新建荣誉等级
     *
     * @author: zsl
     * @since: 2019/6/1 15:52
     */
    public function create()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonor = new lHonor();
            return json($lHonor -> create($param));
        }
    }

    /**
     * @荣誉等级详情
     *
     * @author: zsl
     * @since: 2019/6/1 15:54
     */
    public function detail()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonor = new lHonor();
            return json($lHonor -> detail($param));
        }
    }

    /**
     * @更新荣誉等级
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/6/1 16:15
     */
    public function update()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonor = new lHonor();
            return json($lHonor -> update($param));
        }
    }

    /**
     * @设置荣誉值比例
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/6/1 15:24
     */
    public function setRatio()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonor = new lHonor();
            return json($lHonor -> setRatio($param));
        }
    }

    /**
     * @删除荣誉等级
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/6/3 10:13
     */
    public function delete()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonor = new lHonor();
            return json($lHonor -> delete($param));
        }
    }

    /**
     * @获取荣誉值比例
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/6/1 15:25
     */
    public function getRatio()
    {
        if (request() -> isPost()) {
            $lHonor = new lHonor();
            return json($lHonor -> getRatio());
        }
    }

    /**
     * @查看用户荣誉信息
     *
     * @author: zsl
     * @since: 2019/6/3 11:29
     */
    public function managerHonor()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonor = new lHonor();
            return json($lHonor -> managerHonor($param));
        }
    }

    /**
     * @荣誉等级发送短信通知
     *
     * @author: zsl
     * @since: 2019/6/4 16:21
     */
    public function sendSms()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonor = new lHonor();
            return json($lHonor -> sendSms($param));
        }
    }

}