<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\HonorApply as lHonorApply;

class HonorApply extends Base
{


    /**
     * @特权申请列表
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/6/3 14:27
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonorApply = new lHonorApply();
            return json($lHonorApply -> lists($param));
        }
    }

    /**
     * @申请特权
     *
     * @author: zsl
     * @since: 2019/6/3 17:36
     */
    public function doApply()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonorApply = new lHonorApply();
            return json($lHonorApply -> doApply($param));
        }
        return false;
    }


    /**
     * @申请记录
     *
     * @return \think\response\Json
     *
     * @author: zsl
     * @since: 2019/6/3 19:38
     */
    public function applyRecord()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonorApply = new lHonorApply();
            return json($lHonorApply -> applyRecord($param));
        }
    }

    /**
     * @通过申请
     *
     * @author: zsl
     * @since: 2019/6/4 11:53
     */
    public function pass()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonorApply = new lHonorApply();
            return json($lHonorApply -> pass($param));
        }
    }

    /**
     * @驳回申请
     *
     * @author: zsl
     * @since: 2019/6/4 13:46
     */
    public function reject()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonorApply = new lHonorApply();
            return json($lHonorApply -> reject($param));
        }
    }

    /**
     * @发放特权
     *
     * @author: zsl
     * @since: 2019/6/4 13:48
     */
    public function grant()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonorApply = new lHonorApply();
            return json($lHonorApply -> grant($param));
        }
        return false;
    }

    /**
     * @发送通知短信
     *
     * @author: zsl
     * @since: 2019/6/15 11:59
     */
    public function sendSms()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonorApply = new lHonorApply();
            return json($lHonorApply -> sendSms($param));
        }
    }


    /**
     * @获取用户兑换记录
     *
     * @author: zsl
     * @since: 2019/6/4 14:25
     */
    public function showManagerRecord()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lHonorApply = new lHonorApply();
            return json($lHonorApply -> showManagerRecord($param));
        }
    }

}