<?php

namespace app\admin\controller;

use app\common\api\RedisApi;
use app\common\logic\Index as lIndex;
use think\Db;

class Index extends Base
{


    /**
     * @获取我的信息
     *
     * @author: zsl
     * @since: 2021/3/16 11:36
     */
    public function homePage()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lIndex = new lIndex();
            return json($lIndex -> homePage($param));
        }
        return false;
    }


    /**
     * @推荐游戏
     *
     * @author: zsl
     * @since: 2021/3/24 13:47
     */
    public function recommendGame()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lIndex = new lIndex();
            return json($lIndex -> recommendGame($param));
        }
        return false;
    }


    /**
     * @清除缓存
     *
     * @author: zsl
     * @since: 2021/3/26 9:45
     */
    public function clearCache()
    {
        $result = ['code' => 200, 'msg' => '清除缓存成功', 'data' => []];
        $redis = new RedisApi();
        $key = 'achievements_data_*';
        $keys = $redis -> keys($key);
        $redis -> del($keys);
        return json($result);
    }


    /**
     * @获取未入库数据数量
     *
     * @author: zsl
     * @since: 2021/3/26 10:04
     */
    public function getUnPutCount()
    {
        $result = ['code' => 200, 'msg' => '获取成功', 'data' => []];
        $redis = new RedisApi();
        $register_key = 'register_data';
        $recharge_key = 'recharge_data';
        $result['data'] = [
                'register' => $redis -> lLen($register_key),
                'recharge' => $redis -> lLen($recharge_key),
        ];
        return json($result);
    }


    /**
     * @点击游戏
     *
     * @author: zsl
     * @since: 2021/3/31 17:54
     */
    public function clickGame()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lIndex = new lIndex();
            return json($lIndex -> clickGame($param));
        }
        return false;
    }


    /**
     * @清除演示数据(谨慎执行)
     *
     * @author: zsl
     * @since: 2021/4/1 19:23
     */
    public function truncate()
    {
        $result = ['code' => 200, 'msg' => '清除成功', 'data' => []];
        if (is_truncate()) {
            $result['code'] = 0;
            $result['msg'] = '不可清除';
            return json($result);
        }
        try {
            $sql = [
                    "truncate table oa_department;",
                    "truncate table oa_honor;",
                    "truncate table oa_honor_apply;",
                    "truncate table oa_log;",
                    "delete from oa_manager where id <> 1;",
                    "delete from oa_manager_auth where manager_id <> 1;",
                    "truncate table oa_manager_bank;",
                    "truncate table oa_manager_honor;",
                    "truncate table oa_manager_item;",
                    "truncate table oa_manager_login;",
                    "truncate table oa_manager_login_log;",
                    "truncate table oa_manager_platform;",
                    "truncate table oa_notic;",
                    "truncate table oa_option;",
                    "truncate table oa_platform;",
                    "truncate table oa_recharge;",
                    "truncate table oa_register;",
                    "truncate table oa_role;",
                    "truncate table oa_sms_log;",
                    "truncate table oa_upgrade;",
                    "truncate table oa_wage_diy;",
                    "truncate table oa_wage_month;",
                    "truncate table oa_welfare;",
            ];
            foreach ($sql as $v) {
                Db ::execute($v);
            }
            set_option('sms_info', []);
            set_option('honor_ratio', []);
            set_option('site_info', []);
            @touch(OA_DATA . 'truncate.lock');
        } catch (\Exception $e) {
            $result['code'] = 0;
            $result['msg'] = $e -> getMessage();
            return json($result);
        }
        return json($result);
    }

}
