<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Manager;
use think\captcha\Captcha;
use think\Controller;

class Login extends Controller
{

    /**
     * @api {post} /admin/login/login 员工登录
     * @apiGroup PUBLIC
     * @apiName 员工登录接口
     *
     * @apiDescription 员工登录接口
     *
     * @apiParam {String} $name  账号
     * @apiParam {String} password  密码
     * @apiParam {String} $vertify  验证码
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    用户数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"登录成功","data":{"name":"admin","nickname":"溪谷","honor_name":"","mobile":"13012345678","role_id":0,"is_administrators":1,"manager_access_token":"xx","manager_refresh_token":"xx"}}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":1001,"msg":"验证码错误","data":[]}
     *
     */
    public function login()
    {
        if (request() -> isPost()) {
            $managerModel = new Manager();
            return json($managerModel -> login());
        }
    }

    /**
     * @api {post} /admin/login/logout 员工登出
     * @apiGroup PUBLIC
     * @apiName 员工登出接口
     *
     * @apiDescription 接口描述
     *
     * @apiParam {String} $manager_access_token  用户token
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"登出成功","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {}
     *
     */
    public function logout()
    {
        if (request() -> isPost()) {
            $managerModel = new Manager();
            return json($managerModel -> logout());
        }
    }

    /**
     * @api {post} /admin/login/refreshToekn 刷新员工token
     * @apiGroup PUBLIC
     * @apiName 刷新员工token接口
     *
     * @apiDescription 员工token过期后, 使用refresh_token刷新员工token
     *
     * @apiParam {String} manager_refresh_token  刷新token
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"刷新成功","data":{"name":"admin","nickname":"溪谷","mobile":"13012345678","activation":1,"manager_access_token":"","manager_refresh_token":""}}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":1002,"msg":"身份验证失败","data":[]}
     *
     */
    public function refreshToekn()
    {
        if
        (request() -> isPost()) {
            $managerModel = new Manager();
            return json($managerModel -> refreshToken());
        }
    }

    /**
     * @获取验证码
     *
     */
    public function verify()
    {
        $captcha = new Captcha();
        $captcha -> length = 4;
        $captcha -> codeSet = '0123456789';
        return $captcha -> entry();
    }
}