<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Notic as lNotic;

class Notic extends Base
{


    /**
     * @公告列表
     *
     * @author: zsl
     * @since: 2021/2/25 14:36
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> lists($param));
        }
        return false;
    }

    public function studioNotic()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> studioNotic($param));
        }
    }


    /**
     * @api {post} /admin/notic/categoryNotic 分类公告通知
     * @apiGroup 公告通知
     * @apiName 分类公告通知接口
     *
     * @apiDescription 获取员工公告通知列表
     *
     * @apiParam {String} manager_access_token  用户token
     * @apiParam {String} category  分类(falv:法律法规,gonggao:公告通知,biaoyang:内部表扬)
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     * @apiSuccess {Number} count   公告数量
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"请求成功","data":[],"count":0}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":200,"msg":"请求成功","data":[],"count":0}
     *
     */
    public function categoryNotic()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> categoryNotic($param));
        }
        return false;
    }

    public function create()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> create($param));
        }
    }

    public function detail()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> detail($param));
        }
    }

    public function update()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> update($param));
        }
    }

    public function enable()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> enable($param));
        }
    }

    public function disable()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> disable($param));
        }
    }

    public function delete()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> delete($param));
        }
    }

    public function sort()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lNotic = new lNotic();
            return json($lNotic -> sort($param));
        }
    }

}