<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Role as lRole;

class Role extends Base
{


    /**
     * @api {post} /admin/role/lists 获取角色列表
     * @apiGroup 角色权限
     * @apiName 获取角色列表接口
     *
     * @apiDescription 获取系统中所有角色数据
     *
     * @apiParam {Number} limit  每页显示数量
     * @apiParam {Number} page   当前页数
     * @apiParam {String} manager_access_token  用户token
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     * @apiSuccess {Number} count   记录总数量
     * @apiSuccess {Number} limit   每页显示数量
     * @apiSuccess {Number} count   当前页数
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"","data":[],"count":0,"page":"1","limit":"10"}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":200,"msg":"","data":[],"count":0,"page":"1","limit":"10"}
     *
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lRole = new lRole();
            return json($lRole -> lists($param));
        }
        return false;
    }

    /**
     * @api {post} /admin/role/add 添加角色
     * @apiGroup 角色权限
     * @apiName 添加角色接口
     *
     * @apiDescription 添加员工角色
     *
     * @apiParam {String} manager_access_token  员工token
     * @apiParam {Number} name  角色名称
     * @apiParam {String} remark  角色描述
     * @apiParam {String} status  状态
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"角色添加成功","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":300001,"msg":"角色已存在","data":[]}
     *
     */
    public function add()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lRole = new lRole();
            return json($lRole -> create($param));
        }
        return false;
    }

    /**
     * @api {post} /admin/role/edit 修改角色
     * @apiGroup 角色权限
     * @apiName 修改角色接口
     *
     * @apiDescription 修改员工角色信息接口
     *
     * @apiParam {String} manager_access_token  用户token
     * @apiParam {String} name  角色名称
     * @apiParam {String} remark  角色描述
     * @apiParam {Number} status  角色状态
     * @apiParam {Number} id  角色id
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"角色修改成功","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":300001,"msg":"缺少字段id","data":[]}
     *
     */
    public function edit()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lRole = new lRole();
            return json($lRole -> update($param));
        }
        return false;;
    }

    /**
     * @api {post} /admin/role/rule 修改角色权限
     * @apiGroup 角色权限
     * @apiName 修改角色权限接口
     *
     * @apiDescription 修改角色权限接口
     *
     * @apiParam {String} manager_access_token  员工token
     * @apiParam {Array} auth_ids  角色权限节点id
     * @apiParam {Number} id    角色id
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"权限修改成功","data":[]}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":300004,"msg":"角色不存在，或已被删除","data":[]}
     *
     */
    public function rule()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lRole = new lRole();
            return json($lRole -> rule($param));
        }
    }

    /**
     * @api {post} /admin/role/auth 获取角色权限
     * @apiGroup 角色权限
     * @apiName 获取角色权限接口
     *
     * @apiDescription 获取某个角色当前所有权限
     *
     * @apiParam {String} manager_access_token  员工token
     * @apiParam {Number} id  角色id
     *
     * @apiSuccess {Number} code    状态码，200：请求成功
     * @apiSuccess {String} msg     提示信息
     * @apiSuccess {Object} data    返回数据
     *
     * @apiSuccessExample {json} Success-Response:
     * {"code":200,"msg":"请求成功","data":{"auth_ids":""}}
     *
     * @apiErrorExample {json} Error-Response:
     * {"code":300004,"msg":"角色不存在，或已被删除","data":[]}
     *
     */
    public function auth()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lRole = new lRole();
            return json($lRole -> auth($param));
        }
    }

    public function detail()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lRole = new lRole();
            return json($lRole -> detail($param));
        }
    }

    public function enable()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lRole = new lRole();
            return json($lRole -> enable($param));
        }
    }

    public function disable()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lRole = new lRole();
            return json($lRole -> disable($param));
        }
    }

    public function delete()
    {
        if (request() -> isAjax()) {
            $param = request() -> param();
            $lRole = new lRole();
            return $lRole -> delete($param);
        }
    }



}
