<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\admin\controller;

use app\common\logic\Staff as lStaff;

class Staff extends Base
{


    /**
     * @员工列表
     *
     * @author: zsl
     * @since: 2021/2/25 10:23
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> lists($param));
        }
        return false;
    }


    /**
     * @员工select列表
     *
     * @author: zsl
     * @since: 2019/5/16 10:39
     */
    public function selectLists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> selectLists($param));
        }
    }

    /**
     * @添加员工
     *
     * @author: zsl
     * @since: 2019/5/15 16:21
     *
     */
    public function create()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> create($param));
        }
        return false;
    }


    /**
     * @员工详情
     *
     * @author: zsl
     * @since: 2019/5/16 10:41
     */
    public function detail()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> detail($param));
        }
        return false;
    }

    /**
     * @查看员工信息
     *
     * @author: zsl
     * @since: 2021/3/27 13:58
     */
    public function look()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lManager = new lStaff();
            return json($lManager -> look($param));
        }
        return false;
    }


    /**
     * @更新员工信息
     *
     * @author: zsl
     * @since: 2019/5/16 11:06
     */
    public function update()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> update($param));
        }
        return false;
    }


    /**
     * @启用员工
     *
     * @author: zsl
     * @since: 2019/5/16 14:44
     */
    public function enable()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> enable($param));
        }
        return false;
    }

    /**
     * @禁用员工
     *
     * @author: zsl
     * @since: 2019/5/16 14:45
     */
    public function disable()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> disable($param));
        }
        return false;
    }


    /**
     * @删除员工
     *
     * @author: zsl
     * @since: 2019/5/16 15:19
     */
    public function delete()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> delete($param));
        }
        return false;
    }


    /**
     * @绑定平台
     *
     * @author: zsl
     * @since: 2021/3/2 11:55
     */
    public function bindPlatform()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> bindPlatform($param));
        }
        return false;
    }


    /**
     * @已绑定平台列表
     *
     * @author: zsl
     * @since: 2021/3/2 20:32
     */
    public function bindPlatformLists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> bindPlatformLists($param));
        }
        return false;
    }

    /**
     * @解绑平台
     *
     * @author: zsl
     * @since: 2021/3/3 9:16
     */
    public function unbindPlatform()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lStaff = new lStaff();
            return json($lStaff -> unbindPlatform($param));
        }
        return false;
    }


}
