<?php

namespace app\admin\controller;

use app\common\logic\Upgrade as lUpgrade;

class Upgrade extends Base
{


    /**
     * @更新记录
     *
     * @author: zsl
     * @since: 2021/3/13 11:13
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $lUpgrade = new lUpgrade();
            return json($lUpgrade -> lists());
        }
        return false;
    }

    /**
     * @检查更新
     *
     * @author: zsl
     * @since: 2021/3/13 11:14
     */
    public function check()
    {
        if (request() -> isPost()) {
            $lUpgrade = new lUpgrade();
            return json($lUpgrade -> check());
        }
        return false;
    }

    /**
     * @当前系统版本
     */
    public function currentVersion()
    {
        if (request() -> isPost()) {
            $lUpgrade = new lUpgrade();
            return json($lUpgrade -> currentVersion());
        }
        return false;
    }

    /**
     * @开始更新,检查系统版本
     *
     * @author: zsl
     * @since: 2021/3/25 16:13
     */
    public function begin()
    {
        if (request() -> isPost()) {
            $lUpgrade = new lUpgrade();
            return json($lUpgrade -> begin());
        }
        return false;
    }

    /**
     * @下载更新包
     *
     * @author: zsl
     * @since: 2021/3/25 16:24
     */
    public function setp01()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lUpgrade = new lUpgrade();
            return json($lUpgrade -> setp01($param));
        }
        return false;
    }

    public function setp02()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lUpgrade = new lUpgrade();
            return json($lUpgrade -> setp02($param));
        }
    }

}