<?php

namespace app\admin\controller;

use app\common\logic\Wage as lWage;

class Wage extends Base
{


    /**
     * @工资结算表
     *
     * @author: zsl
     * @since: 2021/3/13 16:06
     */
    public function lists()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWage = new lWage();
            return json($lWage -> lists($param));
        }
        return false;
    }

    /**
     * @导出工资结算表
     *
     * @author: zsl
     * @since: 2021/3/15 9:18
     */
    public function exportExcel()
    {
        $param = request() -> param();
        $param['export'] = true;
        $lWage = new lWage();
        return json($lWage -> lists($param));
    }

    /**
     * @更新薪资结算表
     *
     * @author: zsl
     * @since: 2021/3/15 9:56
     */
    public function update()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWage = new lWage();
            return json($lWage -> update($param));
        }
        return false;
    }


    /**
     * @发放薪资
     *
     * @author: zsl
     * @since: 2021/3/15 9:56
     */
    public function send()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWage = new lWage();
            return json($lWage -> send($param));
        }
        return false;
    }


    /**
     * @发放薪资短信通知
     *
     * @author: zsl
     * @since: 2021/3/24 16:40
     */
    public function message()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWage = new lWage();
            return json($lWage -> message($param));
        }
        return false;
    }

    /**
     * @我的薪资
     *
     * @author: zsl
     * @since: 2021/3/15 9:51
     */
    public function manager()
    {
        if (request() -> isPost()) {
            $param = request() -> param();
            $lWage = new lWage();
            return json($lWage -> manager($param));
        }
        return false;
    }


}