<?php
/**
 * gitee: https://gitee.com/kyle-cao/
 * Created by: admin.dadmin.cn
 * User: imdong
 * Date: 2018/10/23
 * Time: 20:16
 */

namespace app\common\model;

use think\Model;

class Manager extends Model
{
    
    /**
     * @一对一关联 管理员权限表 manager_auth
     *
     * @return \think\model\relation\HasOne
     *
     * @author: imdong
     * @since: 2019/3/21 9:52
     */
    public function auth()
    {
        return $this -> hasOne('ManagerAuth');
    }
    
    /**
     * @一对一关联 管理员登录表 manager_login
     *
     * @return \think\model\relation\HasOne
     *
     * @author: imdong
     * @since: 2019/3/21 10:03
     */
    public function login()
    {
        return $this -> hasOne('ManagerLogin');
    }
    
    /**
     * @一对一关联 商务专员银行卡表 manager_bank
     *
     * @return \think\model\relation\HasOne
     *
     * @author: imdong
     * @since: 2019/3/21 10:04
     */
    public function bank()
    {
        return $this -> hasOne('ManagerBank');
    }
    
    /**
     * @一对多关联 登录日志
     *
     * @author: imdong
     * @since: 2019/3/30 16:10
     */
    public function log()
    {
        return $this -> hasMany('ManagerLoginLog');
    }
    
    public function item()
    {
        return $this -> hasOne('ManagerItem');
    }

    public function platform()
    {
        return $this -> hasMany('ManagerPlatform');
    }

    public function honor()
    {
        return $this -> hasOne('ManagerHonor');
    }
}