<?php

namespace app\common\platform;

class TEMPLATE
{

    private $api;
    private $token;
    private $appid;


    public function __construct($api, $token, $appid)
    {
        $this -> api = json_decode($api, true);
        $this -> token = $token;
        $this -> appid = $appid;
    }

    /**
     * @创建推广员
     *
     * @author: zsl
     * @since: 2021/3/2 16:06
     */
    public function createPromote($param)
    {
        $postData = [];
        $postData['appid'] = $this -> appid;
        $postData['promote_account'] = $param['promote_account'];
        $postData['promote_password'] = $param['promote_password'];
        $postData['t'] = time();
        $postData['sign'] = $this -> sign($postData);
        $content = curl($this -> api['create_promote'], $postData);
        $data = json_decode($content, true);
        return $data;
    }


    /**
     * @验证推广员
     *
     * @author: zsl
     * @since: 2021/3/2 17:03
     */
    public function verifyPromote($param)
    {
        $postData = [];
        $postData['appid'] = $this -> appid;
        $postData['promote_account'] = $param['promote_account'];
        $postData['promote_password'] = $param['promote_password'];
        $postData['t'] = time();
        $postData['sign'] = $this -> sign($postData);
        $content = curl($this -> api['verify_promote'], $postData);
        $data = json_decode($content, true);
        return $data;
    }


    /**
     * @获取可申请游戏列表
     *
     * @author: zsl
     * @since: 2021/3/10 14:02
     */
    public function game($param)
    {
        $postData = [];
        $postData['appid'] = $this -> appid;
        $postData['promote_account'] = $param['promote_account'];
        $postData['t'] = time();
        $postData['sign'] = $this -> sign($postData);
        $postData['sys_type'] = empty($param['sys_type']) ? 1 : $param['sys_type'];
        $postData['page'] = empty($param['page']) ? 1 : $param['page'];
        $postData['limit'] = empty($param['limit']) ? 1 : $param['limit'];
        $postData['game_name'] = empty($param['game_name']) ? '' : $param['game_name'];
        $content = curl($this -> api['game'], $postData);
        return $content;
    }


    /**
     * @申请游戏
     *
     * @author: zsl
     * @since: 2021/3/11 10:18
     */
    public function apply($param)
    {
        $postData = [];
        $postData['appid'] = $this -> appid;
        $postData['game_id'] = $param['game_id'];
        $postData['promote_account'] = $param['promote_account'];
        $postData['t'] = time();
        $postData['sign'] = $this -> sign($postData);
        $content = curl($this -> api['apply'], $postData);
        return $content;
    }


    /**
     * @我的游戏
     *
     * @author: zsl
     * @since: 2021/3/11 11:41
     */
    public function my($param)
    {
        $postData = [];
        $postData['appid'] = $this -> appid;
        $postData['promote_account'] = $param['promote_account'];
        $postData['is_pass'] = $param['is_pass'];
        $postData['t'] = time();
        $postData['sign'] = $this -> sign($postData);
        $postData['game_name'] = empty($param['game_name']) ? '' : $param['game_name'];
        $postData['sdk_version'] = empty($param['sdk_version']) ? '' : $param['sdk_version'];
        $postData['page'] = $param['page'];
        $postData['limit'] = $param['limit'];
        $content = curl($this -> api['my'], $postData);
        return $content;
    }


    /**
     * @渠道打包
     *
     * @author: zsl
     * @since: 2021/3/11 16:23
     */
    public function package($param)
    {
        $postData = [];
        $postData['appid'] = $this -> appid;
        $postData['promote_account'] = $param['promote_account'];
        $postData['game_id'] = $param['game_id'];
        $postData['t'] = time();
        $postData['sign'] = $this -> sign($postData);
        $content = curl($this -> api['package'], $postData);
        return $content;
    }


    /**
     * @拉取注册数据
     *
     * @author: zsl
     * @since: 2021/3/3 10:52
     */
    public function pullRegister($param)
    {
        $postData = [];
        $postData['appid'] = $this -> appid;
        $postData['promote_account'] = $param['promote_account'];
        $postData['last_id'] = $param['last_id'];
        $postData['t'] = time();
        $postData['sign'] = $this -> sign($postData);
        $content = curl($this -> api['register'], $postData);
        return $content;
    }


    /**
     * @拉取充值数据
     *
     * @author: zsl
     * @since: 2021/3/5 10:30
     */
    public function pullRecharge($param)
    {
        $postData = [];
        $postData['appid'] = $this -> appid;
        $postData['promote_account'] = $param['promote_account'];
        $postData['last_id'] = $param['last_id'];
        $postData['t'] = time();
        $postData['sign'] = $this -> sign($postData);
        $content = curl($this -> api['recharge'], $postData);
        return $content;
    }


    private function sign($postData)
    {
        ksort($postData);
        $str = '';
        foreach ($postData as $key => $value) {
            if ($key == 'sign') {
                continue;
            }
            $str .= $key . '=' . $value . '&';
        }
        $str .= 'key=' . $this -> token;
        return md5($str);
    }


}