<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\validate;

use think\Validate;

class Department extends Validate
{


    protected $rule = [
            'id' => 'require|number',
            'name' => 'require|length:2,25|chsAlphaNum|unique:department',
            'status' => 'require|in:0,1',
    ];

    protected $message = [
            'name' => [
                    'require' => '请输入名称',
                    'length' => '名称为2-25个字符',
                    'chsAlphaNum' => '名称为2-25个字符',
                    'unique' => '名称已存在',
            ],
            'status' => [
                    'require' => '请选择状态',
                    'in' => '请选择状态',
            ],
            'id' => [
                    'require' => 'id不能为空',
                    'number' => 'id不能为空',
            ],
    ];

    public function sceneCreate()
    {
        return $this -> only(['name', 'status']);
    }

    public function sceneUpdate()
    {
        return $this -> only(['name', 'status', 'id']);
    }


}