<?php
/**
 * gitee: https://gitee.com/kyle-cao/
 * Created by: admin.dadmin.cn
 * User: imdong
 * Date: 2018/10/23
 * Time: 20:55
 */

namespace app\common\validate;

use think\Validate;

class Manager extends Validate
{
    protected $rule = [
            'role_id' => 'require|integer',
            'name' => 'require|unique:manager',
            'old_password' => 'require',
            'password' => 'require|length:6,30',
            'repassword' => 'require|confirm:password',
            'verify_password' => 'require|length:6,30',
            'reverify_password' => 'require|confirm:verify_password',
            'vertify' => 'require|captcha',
            'realname' => 'require|chs|length:2,25',
            'mobile' => 'require|number',
            'qq' => 'require',
            'status' => 'require|in:0,1',
            'department_id' => 'require|number',
            'idcard_num' => 'idCard',
            'activation' => 'in:0,1',
            'platform_id' => 'require',
            'manager_id' => 'require',
            'promote_account' => 'requireWith:promote_password|length:6,32|alphaDash',
            'promote_password' => 'requireWith:promote_account|length:6,32',
    ];

    protected $message = [
            'role_id' => [
                    'require' => '缺少角色',
                    'integer' => '角色格式错误',
                    'in' => '员工角色错误',
            ],
            'name.require' => '缺少登录名参数',
            'name.unique' => '员工账号已存在,请更换',
            'old_password' => [
                    'require' => '请输入旧密码',
            ],
            'qq' => [
                    'require' => '请输入QQ',
            ],
            'password.require' => '缺少登录密码参数',
            'password.length' => '登录密码为6-30位字符',
            'repassword.require' => '缺少确认登录密码',
            'repassword.confirm' => '确认密码与登录密码不一致',
            'verify_password.require' => '请输入二级密码',
            'verify_password.length' => '二级密码为6-30位字符',
            'reverify_password.require' => '请确认二级密码',
            'reverify_password.confirm' => '确认密码与二级密码不一致',
            'vertify' => [
                    'require' => '缺少验证码参数',
                    'captcha' => '验证码错误',
            ],
            'verify_password' => [
                    'require' => '缺少二级密码',
                    'length' => '二级密码为6-30位字符',
            ],
            'realname' => [
                    'require' => '姓名不能为空',
                    'chs' => '姓名格式错误',
                    'length' => '姓名长度需要在2-25个字符之间',
            ],
            'mobile' => [
                    'require' => '联系电话不能为空',
                    'number' => '联系电话格式错误',
                    'mobile' => '手机号格式错误',
            ],
            'status' => [
                    'require' => '请选择状态',
                    'in' => '请选择状态1',
            ],
            'department_id' => [
                    'require' => '请选择部门',
                    'number' => '请选择部门',
            ],
            'idcard_num' => [
                    'idCard' => '身份证号格式错误'
            ],
            'activation' => [
                    'require' => '请选择状态',
                    'in' => '请选择状态'
            ],
            'platform_id' => [
                    'require' => '请选择平台'
            ],
            'manager_id' => [
                    'require' => '请选择员工'
            ],
            'promote_account' => [
                    'requireWith' => '请输入推广员账号',
                    'length' => '推广员账号长度为6-32位字符',
                    'alphaDash' => '推广员账号不能包含特殊字符',
            ],
            'promote_password' => [
                    'requireWith' => '请输入推广员密码',
                    'length' => '推广员密码长度为6-32位字符',
            ],
    ];

    public function sceneLogin()
    {
        return $this -> only(['name', 'password', 'vertify']) -> remove('name', 'unique');
    }

    public function sceneCreate()
    {
        return $this -> only(['name', 'password', 'repassword', 'role_id', 'verify_password']);
    }

    public function sceneUpdate()
    {
        return $this -> only(['role_id', 'id']) -> append('id', 'require');
    }

    /**
     * @添加员工场景
     *
     * @author: zsl
     * @since: 2019/5/14 11:37
     */
    public function sceneCreateStaff()
    {
        return $this -> only(['name', 'department_id', 'role_id', 'password', 'mobile', 'idcard_num', 'realname', 'status'])
                -> append('mobile', 'mobile')
                -> remove('realname', 'require');
    }

    /**
     * @修改员工场景
     *
     * @author: zsl
     * @since: 2019/5/14 11:37
     */
    public function sceneUpdateStaff()
    {
        return $this -> only(['department_id', 'role_id', 'password', 'mobile', 'realname', 'status', 'verify_password'])
                -> append('mobile', 'mobile')
                -> remove('password', 'require|length:6,30')
                -> remove('verify_password', 'require|length:6,30')
                -> remove('realname', 'require');
    }

    public function sceneUpdateManager()
    {
        return $this -> only(['realname', 'mobile', 'qq']);
    }


    /**
     * @修改密码场景
     *
     * @author: zsl
     * @since: 2019/5/18 10:23
     */
    public function sceneModifypassword()
    {
        return $this -> only(['old_password', 'password', 'repassword']);
    }


    /**
     * @修改二级密码场景
     *
     * @author: zsl
     * @since: 2021/2/26 9:36
     */
    public function sceneModifyVerifyPassword()
    {
        return $this -> only(['verify_password', 'reverify_password']);
    }


    /**
     * @绑定平台验证
     *
     * @author: zsl
     * @since: 2021/3/2 13:54
     */
    public function sceneBind()
    {
        return $this -> only(['platform_id', 'manager_id', 'promote_account', 'promote_password']);
    }

    /**
     * @解绑平台
     *
     * @author: zsl
     * @since: 2021/3/3 9:23
     */
    public function sceneUnbind()
    {
        return $this -> only(['platform_id', 'manager_id']);
    }


}
