<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\validate;

use think\Validate;

class Notic extends Validate
{


    protected $rule = [
            'title' => 'require',
            'description' => 'require',
            'status' => 'in:0,1',
            'start_time' => 'require|number',
            'end_time' => 'require|number',
    ];
    protected $message = [
            'title' => [
                    'require' => '请填写标题',
            ],
            'description' => [
                    'require' => '请填写描述',
            ],
            'status' => [
                    'in' => '请选择状态',
            ],
            'start_time' => [
                    'require' => '请选择开始时间',
                    'number' => '请选择开始时间',
            ],
            'end_time' => [
                    'require' => '请选择结束时间',
                    'number' => '请选择结束时间',
            ],
    ];

    public function sceneCreate()
    {
        return $this -> only(['title', 'description', 'status']);
    }

    public function sceneUpdate()
    {
        return $this -> only(['title', 'description', 'status']);
    }


}