<?php
/**
 * @Copyright (c) 2019  XIGU Inc. All rights reserved.
 * @Link https://www.vlcms.com
 * @License江苏溪谷网络科技有限公司版权所有
 */

namespace app\common\validate;

use think\Validate;

class Platform extends Validate
{
    protected $rule = [
            'id' => 'require|integer',
            'name' => 'require',
            'ename' => 'require|unique:platform',
            'token' => 'require',
            'api' => 'require',
            'api_register' => 'require',
            'api_recharge' => 'require',
            'api_server' => 'require',
            'api_game_role' => 'require',
            'api_game' => 'require',
            'api_game_type' => 'require',
            'tel' => 'mobile',
    ];

    protected $message = [
            'id' => [
                    'require' => '缺少ID',
                    'integer' => 'id格式不正确'
            ],
            'name.require' => '缺少渠道名称',
            'ename.require' => '缺少渠道标识',
            'ename.unique' => '渠道标识已存在',
            'api.require' => '请填写接口地址',
            'api_register.require' => '缺少注册接口',
            'api_recharge.require' => '缺少充值接口',
            'api_server.require' => '缺少区服接口',
            'api_game_role.require' => '缺少游戏角色接口',
            'api_game.require' => '缺少游戏接口',
            'api_game_type.require' => '缺少游戏类型接口',
            'token.require' => '缺少token',
            'tel.mobile' => '电话格式不正确'
    ];

    public function sceneCreate()
    {
        return $this -> only(['name', 'ename', 'api', 'tel']);
    }

    public function sceneModify()
    {
        return $this -> only(['id', 'name', 'ename', 'api', 'tel']);
    }

    public function sceneDetail()
    {
        return $this -> only(['id']);
    }

}
