/*
Navicat MySQL Data Transfer

Source Server         : local
Source Server Version : 50719
Source Host           : 127.0.0.1:3306
Source Database       : oa_init

Target Server Type    : MYSQL
Target Server Version : 50719
File Encoding         : 65001

Date: 2021-04-02 10:24:35
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for oa_auth
-- ----------------------------
DROP TABLE IF EXISTS `oa_auth`;
CREATE TABLE `oa_auth` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `title` varchar(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '菜单标题',
  `module` varchar(20) NOT NULL DEFAULT '' COMMENT '所属模块',
  `controller` varchar(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '所属控制器',
  `action` varchar(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '所属方法',
  `route_name` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '路由别名',
  `route_url` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '路由url',
  `param` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '参数',
  `iconfont` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '图标',
  `remark` varchar(200) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '备注',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '0:无链接的菜单 1:有链接的菜单 2:有链接的功能',
  `sort` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `module` (`module`,`controller`,`action`) USING BTREE,
  KEY `sort` (`sort`) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=141 DEFAULT CHARSET=utf8 COMMENT='菜单节点表';

-- ----------------------------
-- Records of oa_auth
-- ----------------------------
INSERT INTO `oa_auth` VALUES ('1', '0', '首页', '', '', '', '', '', '', '', '', '0', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('2', '0', '用户管理', '', '', '', '', '', '', 'mdi-home', '', '0', '1', '1', '1558401664', '1558401664');
INSERT INTO `oa_auth` VALUES ('3', '0', '游戏管理', '', '', '', '', '', '', '', '', '0', '2', '1', '1606361994', '1606361994');
INSERT INTO `oa_auth` VALUES ('4', '0', '数据管理', '', '', '', '', '', ' ', 'mdi-account-group-outline', ' ', '0', '3', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('5', '0', '财务管理', '', '', '', '', '', ' ', 'mdi-account-group-outline', ' ', '0', '4', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('6', '0', '荣誉管理', '', '', '', '', '', '', 'mdi-av-timer', '', '0', '5', '1', '1558404393', '1558404393');
INSERT INTO `oa_auth` VALUES ('7', '0', '系统管理', '', '', '', '', '', '', 'mdi-av-timer', '', '0', '6', '1', '1558404393', '1558404393');
INSERT INTO `oa_auth` VALUES ('8', '0', '平台对接', '', '', '', '', '', '', '', '', '0', '7', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('10', '2', '角色权限', '', '', '', '', '', '', '', '', '0', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('11', '2', '部门列表', '', '', '', '', '', '', '', '', '0', '2', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('12', '2', '员工列表', '', '', '', '', '', '', '', '', '0', '3', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('13', '7', '账户信息', '', '', '', '', '', '', '', '', '0', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('14', '7', '公告通知(设置)', '', '', '', '', '', '', '', '', '0', '2', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('15', '7', '短信设置', '', '', '', '', '', '', '', '', '0', '3', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('16', '7', '系统更新', '', '', '', '', '', '', '', '', '0', '4', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('17', '6', '荣誉明细', '', '', '', '', '', '', '', '', '0', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('18', '6', '荣誉设置', '', '', '', '', '', '', '', '', '0', '2', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('19', '6', '特权申请', '', '', '', '', '', '', '', '', '0', '3', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('20', '6', '特权审核', '', '', '', '', '', '', '', '', '0', '4', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('21', '6', '福利设置', '', '', '', '', '', '', '', '', '0', '5', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('22', '5', '薪资设置', '', '', '', '', '', '', '', '', '0', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('23', '5', '薪资结算', '', '', '', '', '', '', '', '', '0', '2', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('24', '5', '员工薪资', '', '', '', '', '', '', '', '', '0', '3', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('25', '8', '我的平台', '', '', '', '', '', '', '', '', '0', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('26', '8', '平台中心', '', '', '', '', '', '', '', '', '0', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('27', '3', '游戏中心', '', '', '', '', '', '', '', '', '0', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('28', '3', '我的游戏', '', '', '', '', '', '', '', '', '0', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('29', '3', '渠道游戏', '', '', '', '', '', '', '', '', '0', '1', '0', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('30', '4', '数据汇总', '', '', '', '', '', ' ', '', ' ', '0', '3', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('31', '4', '充值明细', '', '', '', '', '', ' ', '', ' ', '0', '3', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('32', '4', '注册明细', '', '', '', '', '', ' ', '', ' ', '0', '3', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('33', '4', '业绩总览', '', '', '', '', '', ' ', '', ' ', '0', '3', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('34', '4', '今日业绩', '', '', '', '', '', ' ', '', ' ', '0', '3', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('35', '4', '业绩排行', '', '', '', '', '', ' ', '', ' ', '0', '3', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('36', '30', '数据汇总', 'admin', 'Data', 'summarize', 'admin/data/summarize', 'admin/data/summarize', ' ', '', ' ', '1', '3', '1', '1552996722', '1552996722');
INSERT INTO `oa_auth` VALUES ('37', '12', '员工列表', 'admin', 'staff', 'lists', 'admin/staff/lists', 'admin/staff/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('38', '12', '创建员工', 'admin', 'staff', 'create', 'admin/staff/create', 'admin/staff/create', '', '', '', '1', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('39', '12', '更新员工信息', 'admin', 'staff', 'update', 'admin/staff/update', 'admin/staff/update', '', '', '', '1', '2', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('40', '12', '员工详情', 'admin', 'staff', 'detail', 'admin/staff/detail', 'admin/staff/detail', '', '', '', '1', '3', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('41', '12', '启用员工', 'admin', 'staff', 'enable', 'admin/staff/enable', 'admin/staff/enable', '', '', '', '1', '4', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('42', '12', '禁用员工', 'admin', 'staff', 'disable', 'admin/staff/disable', 'admin/staff/disable', '', '', '', '1', '5', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('43', '12', '绑定平台', 'admin', 'staff', 'bindPlatform', 'admin/staff/bindPlatform', 'admin/staff/bindPlatform', '', '', '', '1', '6', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('44', '12', '已绑定平台列表', 'admin', 'staff', 'bindPlatformLists', 'admin/staff/bindPlatformLists', 'admin/staff/bindPlatformLists', '', '', '', '1', '7', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('45', '12', '解绑平台', 'admin', 'staff', 'unbindPlatform', 'admin/staff/unbindPlatform', 'admin/staff/unbindPlatform', '', '', '', '1', '8', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('46', '1', '首页数据', 'admin', 'index', 'homePage', 'admin/index/homePage', 'admin/index/homePage', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('47', '10', '角色列表', 'admin', 'role', 'lists', 'admin/role/lists', 'admin/role/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('48', '10', '添加角色', 'admin', 'role', 'add', 'admin/role/add', 'admin/role/add', '', '', '', '1', '1', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('49', '10', '编辑角色', 'admin', 'role', 'edit', 'admin/role/edit', 'admin/role/edit', '', '', '', '1', '2', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('50', '10', '获取角色当前权限', 'admin', 'role', 'auth', 'admin/role/auth', 'admin/role/auth', '', '', '', '1', '3', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('51', '10', '修改角色权限', 'admin', 'role', 'rule', 'admin/role/rule', 'admin/role/rule', '', '', '', '1', '4', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('52', '11', '部门列表', 'admin', 'department', 'lists', 'admin/department/lists', 'admin/department/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('53', '11', '部门详情', 'admin', 'department', 'detail', 'admin/department/detail', 'admin/department/detail', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('54', '11', '添加部门', 'admin', 'department', 'create', 'admin/department/create', 'admin/department/create', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('55', '11', '更新部门', 'admin', 'department', 'update', 'admin/department/update', 'admin/department/update', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('56', '11', '启用部门', 'admin', 'department', 'enable', 'admin/department/enable', 'admin/department/enable', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('57', '11', '禁用部门', 'admin', 'department', 'disable', 'admin/department/disable', 'admin/department/disable', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('58', '27', '游戏中心', 'admin', 'game', 'center', 'admin/game/center', 'admin/game/center', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('59', '27', '申请游戏', 'admin', 'game', 'apply', 'admin/game/apply', 'admin/game/apply', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('60', '28', '我的游戏', 'admin', 'game', 'my', 'admin/game/my', 'admin/game/my', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('61', '28', '渠道游戏打包', 'admin', 'game', 'package', 'admin/game/package', 'admin/game/package', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('62', '14', '公告列表', 'admin', 'notic', 'lists', 'admin/notic/lists', 'admin/notic/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('63', '14', '添加公告', 'admin', 'notic', 'create', 'admin/notic/create', 'admin/notic/create', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('64', '14', '公告详情', 'admin', 'notic', 'detail', 'admin/notic/detail', 'admin/notic/detail', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('65', '14', '更新公告', 'admin', 'notic', 'update', 'admin/notic/update', 'admin/notic/update', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('66', '14', '启用公告', 'admin', 'notic', 'enable', 'admin/notic/enable', 'admin/notic/enable', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('67', '14', '禁用公告', 'admin', 'notic', 'disable', 'admin/notic/disable', 'admin/notic/disable', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('68', '14', '删除公告', 'admin', 'notic', 'delete', 'admin/notic/delete', 'admin/notic/delete', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('69', '14', '公告排序', 'admin', 'notic', 'sort', 'admin/notic/sort', 'admin/notic/sort', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('70', '15', '获取短信配置', 'admin', 'system', 'getSMSInfo', 'admin/system/getSMSInfo', 'admin/system/getSMSInfo', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('71', '15', '设置短信配置', 'admin', 'system', 'setSMSInfo', 'admin/system/setSMSInfo', 'admin/system/setSMSInfo', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('72', '13', '获取账号信息', 'admin', 'manager', 'info', 'admin/manager/info', 'admin/manager/info', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('73', '13', '更新当前登录用户信息', 'admin', 'manager', 'saveInfo', 'admin/manager/saveInfo', 'admin/manager/saveInfo', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('74', '13', '更新当前登录用户银行', 'admin', 'manager', 'saveBankInfo', 'admin/manager/saveBankInfo', 'admin/manager/saveBankInfo', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('75', '13', '修改密码', 'admin', 'manager', 'modifypassword', 'admin/manager/modifypassword', 'admin/manager/modifypassword', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('76', '13', '修改二级密码', 'admin', 'manager', 'modifyVerifyPassword', 'admin/manager/modifyVerifyPassword', 'admin/manager/modifyVerifyPassword', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('77', '13', '修改用户头像', 'admin', 'manager', 'modifyavatar', 'admin/manager/modifyavatar', 'admin/manager/modifyavatar', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('78', '21', '福利列表', 'admin', 'welfare', 'lists', 'admin/welfare/lists', 'admin/welfare/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('79', '21', '新建福利', 'admin', 'welfare', 'create', 'admin/welfare/create', 'admin/welfare/create', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('80', '21', '福利详情', 'admin', 'welfare', 'detail', 'admin/welfare/detail', 'admin/welfare/detail', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('81', '21', '更新福利', 'admin', 'welfare', 'update', 'admin/welfare/update', 'admin/welfare/update', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('82', '21', '删除福利', 'admin', 'welfare', 'delete', 'admin/welfare/delete', 'admin/welfare/delete', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('83', '17', '荣誉明细', 'admin', 'honor', 'managerHonor', 'admin/honor/managerHonor', 'admin/honor/managerHonor', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('84', '18', '荣誉列表', 'admin', 'honor', 'lists', 'admin/honor/lists', 'admin/honor/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('85', '18', '新建荣誉等级', 'admin', 'honor', 'create', 'admin/honor/create', 'admin/honor/create', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('86', '18', '荣誉等级详情', 'admin', 'honor', 'detail', 'admin/honor/detail', 'admin/honor/detail', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('87', '18', '更新荣誉等级', 'admin', 'honor', 'update', 'admin/honor/update', 'admin/honor/update', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('88', '18', '删除荣誉等级', 'admin', 'honor', 'delete', 'admin/honor/delete', 'admin/honor/delete', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('89', '18', '获取荣誉值比例', 'admin', 'honor', 'getRatio', 'admin/honor/getRatio', 'admin/honor/getRatio', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('90', '18', '设置荣誉比例值', 'admin', 'honor', 'setRatio', 'admin/honor/setRatio', 'admin/honor/setRatio', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('91', '19', '特权列表', 'admin', 'HonorApply', 'lists', 'admin/Honor_apply/lists', 'admin/HonorApply/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('92', '19', '申请特权', 'admin', 'HonorApply', 'doApply', 'admin/Honor_apply/doApply', 'admin/HonorApply/doApply', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('93', '20', '特权申请记录', 'admin', 'HonorApply', 'applyRecord', 'admin/Honor_apply/applyRecord', 'admin/HonorApply/applyRecord', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('94', '20', '通过申请', 'admin', 'HonorApply', 'pass', 'admin/Honor_apply/pass', 'admin/HonorApply/pass', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('95', '20', '驳回申请', 'admin', 'HonorApply', 'reject', 'admin/Honor_apply/reject', 'admin/HonorApply/reject', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('96', '20', '发放申请', 'admin', 'HonorApply', 'grant', 'admin/Honor_apply/grant', 'admin/HonorApply/grant', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('97', '22', '薪资设置列表', 'admin', 'wageDiy', 'lists', 'admin/wage_diy/lists', 'admin/wageDiy/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('98', '22', '更新薪资设置', 'admin', 'wageDiy', 'update', 'admin/wage_diy/update', 'admin/wageDiy/update', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('99', '22', '薪资设置详情', 'admin', 'wageDiy', 'detail', 'admin/wage_diy/detail', 'admin/wageDiy/detail', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('100', '22', '创建薪资设置', 'admin', 'wageDiy', 'create', 'admin/wage_diy/create', 'admin/wageDiy/create', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('101', '23', '薪资结算表', 'admin', 'wage', 'lists', 'admin/wage/lists', 'admin/wage/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('102', '23', '导出薪资结算表', 'admin', 'wage', 'exportExcel', 'admin/wage/exportExcel', 'admin/wage/exportExcel', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('103', '23', '发放薪资', 'admin', 'wage', 'send', 'admin/wage/send', 'admin/wage/send', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('104', '23', '修改薪资', 'admin', 'wage', 'update', 'admin/wage/update', 'admin/wage/update', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('105', '24', '员工薪资', 'admin', 'wage', 'manager', 'admin/wage/manager', 'admin/wage/manager', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('106', '25', '我申请的渠道列表', 'admin', 'platform', 'mine', 'admin/platform/mine', 'admin/platform/mine', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('107', '25', '添加渠道', 'admin', 'platform', 'mineCreate', 'admin/platform/mineCreate', 'admin/platform/mineCreate', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('108', '25', '渠道详情', 'admin', 'platform', 'detail', 'admin/platform/detail', 'admin/platform/detail', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('109', '25', '更新渠道', 'admin', 'platform', 'mineUpdate', 'admin/platform/mineUpdate', 'admin/platform/mineUpdate', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('110', '26', '渠道中心列表', 'admin', 'platform', 'lists', 'admin/platform/lists', 'admin/platform/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('111', '26', '激活渠道', 'admin', 'platform', 'apply', 'admin/platform/apply', 'admin/platform/apply', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('112', '30', '数据汇总', 'admin', 'data', 'summarize', 'admin/data/summarize', 'admin/data/summarize', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('113', '30', '查看注册账号', 'admin', 'data', 'viewRegister', 'admin/data/viewRegister', 'admin/data/viewRegister', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('114', '30', '查看充值账号', 'admin', 'data', 'viewRecharge', 'admin/data/viewRecharge', 'admin/data/viewRecharge', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('115', '31', '充值明细', 'admin', 'data', 'recharge', 'admin/data/recharge', 'admin/data/recharge', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('116', '32', '注册明细', 'admin', 'data', 'register', 'admin/data/register', 'admin/data/register', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('117', '33', '业绩总览', 'admin', 'achievements', 'overview', 'admin/achievements/overview', 'admin/achievements/overview', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('118', '35', '业绩排行:日排行', 'admin', 'rank', 'day', 'admin/rank/day', 'admin/rank/day', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('119', '35', '业绩排行:周排行', 'admin', 'rank', 'week', 'admin/rank/week', 'admin/rank/week', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('120', '35', '业绩排行:月排行', 'admin', 'rank', 'month', 'admin/rank/month', 'admin/rank/month', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('121', '35', '业绩排行:季排行', 'admin', 'rank', 'season', 'admin/rank/season', 'admin/rank/season', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('122', '1', '获取推荐游戏', 'admin', 'index', 'recommendGame', 'admin/index/recommendGame', 'admin/index/recommendGame', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('123', '1', '获取未入库数据数量', 'admin', 'index', 'getUnPutCount', 'admin/index/getUnPutCount', 'admin/index/getUnPutCount', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('124', '34', '今日业绩', 'admin', 'achievements', 'overviewDetail', 'admin/achievements/overviewDetail', 'admin/achievements/overviewDetail', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('125', '16', '更新记录', 'admin', 'upgrade', 'lists', 'admin/upgrade/lists', 'admin/upgrade/lists', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('126', '16', '检测升级', 'admin', 'upgrade', 'check', 'admin/upgrade/check', 'admin/upgrade/check', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('127', '16', '获取当前版本', 'admin', 'upgrade', 'currentVersion', 'admin/upgrade/currentVersion', 'admin/upgrade/currentVersion', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('128', '16', '开始更新', 'admin', 'upgrade', 'begin', 'admin/upgrade/begin', 'admin/upgrade/begin', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('129', '16', '下载更新包', 'admin', 'upgrade', 'setp01', 'admin/upgrade/setp01', 'admin/upgrade/setp01', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('130', '16', '解压更新包', 'admin', 'upgrade', 'setp02', 'admin/upgrade/setp02', 'admin/upgrade/setp02', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('131', '16', '执行更新程序', 'upgrade', 'index', 'step01', 'upgrade/index/step01', 'upgrade/index/step01', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('132', '12', '查看员工信息', 'admin', 'staff', 'look', 'admin/staff/look', 'admin/staff/look', '', '', '', '1', '3', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('133', '35', '业绩排行:昨日排行', 'admin', 'rank', 'yesterday', 'admin/rank/yesterday', 'admin/rank/yesterday', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('134', '17', '兑换记录', 'admin', 'HonorApply', 'showManagerRecord', 'admin/Honor_apply/showManagerRecord', 'admin/Honor_apply/showManagerRecord', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('135', '17', '荣誉等级通知', 'admin', 'honor', 'sendSms', 'admin/honor/sendSms', 'admin/honor/sendSms', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('136', '10', '启用角色', 'admin', 'role', 'enable', 'admin/role/enable', 'admin/role/enable', '', '', '', '1', '4', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('137', '10', '禁用角色', 'admin', 'role', 'disable', 'admin/role/disable', 'admin/role/disable', '', '', '', '1', '4', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('138', '7', '基础设置', '', '', '', '', '', '', '', '', '0', '5', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('139', '138', '获取基础设置', 'admin', 'baseSetting', 'getSiteInfo', 'admin/baseSetting/getSiteInfo', 'admin/baseSetting/getSiteInfo', '', '', '', '1', '0', '1', '1606199558', '1606199558');
INSERT INTO `oa_auth` VALUES ('140', '138', '保存基础设置', 'admin', 'baseSetting', 'setSiteInfo', 'admin/baseSetting/setSiteInfo', 'admin/baseSetting/setSiteInfo', '', '', '', '1', '0', '1', '1606199558', '1606199558');

-- ----------------------------
-- Table structure for oa_config
-- ----------------------------
DROP TABLE IF EXISTS `oa_config`;
CREATE TABLE `oa_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '配置名称',
  `type` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '配置类型',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '配置说明',
  `value` text NOT NULL COMMENT '配置值',
  `remark` varchar(100) NOT NULL DEFAULT '' COMMENT '配置说明',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_name` (`name`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=91 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of oa_config
-- ----------------------------
INSERT INTO `oa_config` VALUES ('89', 'version_name', '1', '版本名称', 'V2.1.0', '', '0', '1', '1558947946', '1558947946');
INSERT INTO `oa_config` VALUES ('90', 'version_code', '1', '版本号', '210', '', '0', '1', '1558948009', '1558948009');

-- ----------------------------
-- Table structure for oa_department
-- ----------------------------
DROP TABLE IF EXISTS `oa_department`;
CREATE TABLE `oa_department` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `name` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '部门名称',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '-1:删除 0:锁定 1:正常',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='部门表';

-- ----------------------------
-- Records of oa_department
-- ----------------------------
INSERT INTO `oa_department` VALUES ('1', '0', '优秀游戏推广部', '1', '1616811449', '1616811449');
INSERT INTO `oa_department` VALUES ('2', '1', '推广1部', '1', '1616811474', '1616826572');
INSERT INTO `oa_department` VALUES ('3', '1', '推广2部', '1', '1616826492', '1616826578');
INSERT INTO `oa_department` VALUES ('4', '1', '推广3部', '1', '1616826509', '1616826583');
INSERT INTO `oa_department` VALUES ('5', '1', '推广4部', '1', '1616826518', '1616826588');
INSERT INTO `oa_department` VALUES ('6', '2', '推广1部小组1', '1', '1616826600', '1616826619');
INSERT INTO `oa_department` VALUES ('7', '2', '推广1部小组2', '1', '1616826625', '1616826625');
INSERT INTO `oa_department` VALUES ('8', '0', '推广5部', '1', '1617085581', '1617085590');

-- ----------------------------
-- Table structure for oa_honor
-- ----------------------------
DROP TABLE IF EXISTS `oa_honor`;
CREATE TABLE `oa_honor` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '荣誉名称',
  `rank` varchar(50) NOT NULL DEFAULT '' COMMENT '推广等级',
  `honor_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '荣誉值',
  `privilege` varchar(255) NOT NULL DEFAULT '' COMMENT '特权',
  `manager_id` int(10) NOT NULL DEFAULT '0' COMMENT '编辑者员工id',
  `create_time` int(10) NOT NULL,
  `update_time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `manager_id` (`manager_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COMMENT='荣誉等级';

-- ----------------------------
-- Records of oa_honor
-- ----------------------------
INSERT INTO `oa_honor` VALUES ('1', '精英推广', '预备组长', '30', '[{\"title\":\"安卓手机使用权\",\"icon\":\"\"}]', '2', '1616807950', '1617003174', '1');
INSERT INTO `oa_honor` VALUES ('2', '白金推广', '组长', '1000', '[{\"title\":\"高档机械键鼠使用权\",\"icon\":\"\"}]', '2', '1616808149', '1617070470', '1');
INSERT INTO `oa_honor` VALUES ('3', '钻石推广', '预备主管', '900', '[{\"title\":\"  高端耳机使用权\",\"icon\":\"\"},{\"title\":\"  底薪增加100元\",\"icon\":\"\"},{\"title\":\"调休1天\",\"icon\":\"\"},{\"title\":\"中档住房\",\"icon\":\"\"}]', '2', '1616825854', '1617070513', '1');
INSERT INTO `oa_honor` VALUES ('4', '紫金推广', '主管', '40000', '[{\"title\":\"  平板电脑使用权\",\"icon\":\"\"},{\"title\":\"  底薪增加200元\",\"icon\":\"\"},{\"title\":\"每年带薪假期3天\",\"icon\":\"\"}]', '1', '1616825892', '1616825892', '1');
INSERT INTO `oa_honor` VALUES ('5', '推广大师', '预备经理', '50000', '[{\"title\":\"  苹果手机\",\"icon\":\"\"},{\"title\":\"底薪增加300元\",\"icon\":\"\"},{\"title\":\"高端住房\",\"icon\":\"\"}]', '1', '1616825924', '1616825924', '1');
INSERT INTO `oa_honor` VALUES ('6', '推广专家', '经理', '60000', '[{\"title\":\"  苹果电脑  \",\"icon\":\"\"},{\"title\":\"底薪增加400元\",\"icon\":\"\"}]', '1', '1616825948', '1616825948', '1');
INSERT INTO `oa_honor` VALUES ('7', '1号等级', '1号', '2', '[{\"title\":\"游戏皮肤\",\"icon\":\"20210331\\/6bf6b2168d8056c10ef7069365e84fce.jpg\"}]', '2', '1617155440', '1617155440', '-1');

-- ----------------------------
-- Table structure for oa_honor_apply
-- ----------------------------
DROP TABLE IF EXISTS `oa_honor_apply`;
CREATE TABLE `oa_honor_apply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `manager_id` int(10) NOT NULL DEFAULT '0',
  `honor_id` int(10) NOT NULL,
  `privilege` varchar(255) NOT NULL DEFAULT '',
  `honor_num` int(10) NOT NULL DEFAULT '0',
  `current_honor_num` int(10) NOT NULL DEFAULT '0',
  `create_time` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `manager_id,honor_id` (`manager_id`,`honor_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of oa_honor_apply
-- ----------------------------
INSERT INTO `oa_honor_apply` VALUES ('1', '2', '1', '[{\"title\":\"安卓手机使用权\",\"icon\":\"\"}]', '2', '1000', '1616997435', '3');
INSERT INTO `oa_honor_apply` VALUES ('2', '2', '1', '[{\"title\":\"安卓手机使用权\",\"icon\":\"\"}]', '30', '970', '1617003375', '3');
INSERT INTO `oa_honor_apply` VALUES ('3', '2', '1', '[{\"title\":\"安卓手机使用权\",\"icon\":\"\"}]', '30', '940', '1617003598', '3');
INSERT INTO `oa_honor_apply` VALUES ('4', '2', '2', '[{\"title\":\"高档机械键鼠使用权\",\"icon\":\"\"}]', '1500', '940', '1617019972', '3');
INSERT INTO `oa_honor_apply` VALUES ('6', '2', '3', '[{\"title\":\"  高端耳机使用权\",\"icon\":\"\"},{\"title\":\"  底薪增加100元\",\"icon\":\"\"},{\"title\":\"调休1天\",\"icon\":\"\"},{\"title\":\"中档住房\",\"icon\":\"\"}]', '900', '40', '1617089295', '2');
INSERT INTO `oa_honor_apply` VALUES ('7', '2', '7', '[{\"title\":\"游戏皮肤\",\"icon\":\"20210331\\/6bf6b2168d8056c10ef7069365e84fce.jpg\"}]', '2', '38', '1617155450', '0');
INSERT INTO `oa_honor_apply` VALUES ('8', '2', '1', '[{\"title\":\"安卓手机使用权\",\"icon\":\"\"}]', '30', '8', '1617156504', '0');

-- ----------------------------
-- Table structure for oa_log
-- ----------------------------
DROP TABLE IF EXISTS `oa_log`;
CREATE TABLE `oa_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作员工id',
  `module` char(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '操作模块',
  `controller` char(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '控制器',
  `action` char(20) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '操作方法',
  `param` text CHARACTER SET utf8mb4 NOT NULL COMMENT '请求参数',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '请求时间',
  PRIMARY KEY (`id`),
  KEY `manager_id` (`manager_id`),
  KEY `module` (`module`) USING BTREE,
  KEY `controller` (`controller`) USING BTREE,
  KEY `action` (`action`) USING BTREE,
  KEY `create_time` (`create_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of oa_log
-- ----------------------------

-- ----------------------------
-- Table structure for oa_manager
-- ----------------------------
DROP TABLE IF EXISTS `oa_manager`;
CREATE TABLE `oa_manager` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户主键',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级员工id',
  `name` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '姓名',
  `nickname` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '昵称',
  `realname` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '真实姓名',
  `avatar` varchar(200) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '头像',
  `mobile` char(11) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '手机号',
  `email` varchar(30) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '邮箱',
  `qq` varchar(30) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'QQ号',
  `duty` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '职务',
  `password` char(32) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '密码',
  `verify_password` char(32) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '二级密码',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `entry_date` char(10) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '入职日期',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `creator_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建者',
  `creator` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '创建者',
  `activation` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '激活状态(0:未激活，1:已激活)',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='员工表';

-- ----------------------------
-- Records of oa_manager
-- ----------------------------
INSERT INTO `oa_manager` VALUES ('1', '0', 'admin', '溪谷科技', '溪谷科技', '20210401/fe971d9fe94c869057552317741a8957.png', '15949009645', '', '123456', '超级管理员', 'b85bab28f56adf1259b68a59aa1f8fa7', 'b85bab28f56adf1259b68a59aa1f8fa7', '1', '2021-01-01', '1542111052', '1617261003', '1', 'admin', '1');
INSERT INTO `oa_manager` VALUES ('2', '1', 'ceshioa', 'ceshioa', '谢莎莎', '', '15936203633', '', '1514320045', '', 'b85bab28f56adf1259b68a59aa1f8fa7', '82356c6f2897b75aa6294583d23a95b5', '1', '2021-03-27', '1616811538', '1617269734', '1', 'admin', '1');
INSERT INTO `oa_manager` VALUES ('3', '2', 'ceshioa1', 'ceshioa1', '姜海秦', '', '15689527589', '', '', '', 'b85bab28f56adf1259b68a59aa1f8fa7', 'b85bab28f56adf1259b68a59aa1f8fa7', '1', '2021-03-29', '1616812115', '1617089135', '2', 'ceshioa', '1');
INSERT INTO `oa_manager` VALUES ('4', '1', 'liudidi', 'liudidi', '迪迪', '', '15689527589', '', '', '', 'b85bab28f56adf1259b68a59aa1f8fa7', '82356c6f2897b75aa6294583d23a95b5', '1', '2021-01-01', '1616826732', '1617269727', '1', 'admin', '1');
INSERT INTO `oa_manager` VALUES ('5', '2', 'ceshioa2', 'ceshioa2', '李哈哈', '', '15936203633', '', '', '', 'b85bab28f56adf1259b68a59aa1f8fa7', '82356c6f2897b75aa6294583d23a95b5', '1', '2021-03-29', '1616987007', '1617245571', '4', 'liudidi', '1');
INSERT INTO `oa_manager` VALUES ('6', '5', '18361334554', '18361334554', '吕贵显', '', '18361334554', '', '', '', '92752f9529a9e94511dba9698fa93283', '92752f9529a9e94511dba9698fa93283', '1', '2021-03-29', '1617010356', '1617095117', '5', 'ceshioa2', '1');
INSERT INTO `oa_manager` VALUES ('7', '2', 'ceshioa3', 'ceshioa3', '刘海元', '', '15936203633', '', '', '', 'b85bab28f56adf1259b68a59aa1f8fa7', 'b85bab28f56adf1259b68a59aa1f8fa7', '1', '2021-03-29', '1617016952', '1617269672', '1', 'admin', '1');
INSERT INTO `oa_manager` VALUES ('8', '0', 'csstaff', 'csstaff', '范德萨', '', '18877776666', '', '', '', 'b85bab28f56adf1259b68a59aa1f8fa7', 'b85bab28f56adf1259b68a59aa1f8fa7', '1', '2021-04-01', '1617093566', '1617271088', '1', 'admin', '1');
INSERT INTO `oa_manager` VALUES ('9', '0', 'ceshioa4', 'ceshioa4', '刘云鹤', '', '17785690236', '', '', '', 'b85bab28f56adf1259b68a59aa1f8fa7', 'b85bab28f56adf1259b68a59aa1f8fa7', '1', '2021-03-30', '1617095432', '1617269689', '1', 'admin', '1');
INSERT INTO `oa_manager` VALUES ('10', '2', 'ceshio1', 'ceshio1', '袁启程', '', '15556230259', '', '', '事务', 'b85bab28f56adf1259b68a59aa1f8fa7', 'b85bab28f56adf1259b68a59aa1f8fa7', '1', '2021-04-09', '1617240676', '1617241077', '2', 'ceshioa', '1');

-- ----------------------------
-- Table structure for oa_manager_auth
-- ----------------------------
DROP TABLE IF EXISTS `oa_manager_auth`;
CREATE TABLE `oa_manager_auth` (
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `role_id` int(10) NOT NULL DEFAULT '0' COMMENT '角色id',
  PRIMARY KEY (`manager_id`) USING BTREE,
  KEY `manager_id` (`manager_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='员工权限关联表';

-- ----------------------------
-- Records of oa_manager_auth
-- ----------------------------
INSERT INTO `oa_manager_auth` VALUES ('1', '0');
INSERT INTO `oa_manager_auth` VALUES ('2', '1');
INSERT INTO `oa_manager_auth` VALUES ('3', '2');
INSERT INTO `oa_manager_auth` VALUES ('4', '1');
INSERT INTO `oa_manager_auth` VALUES ('5', '1');
INSERT INTO `oa_manager_auth` VALUES ('6', '1');
INSERT INTO `oa_manager_auth` VALUES ('7', '1');
INSERT INTO `oa_manager_auth` VALUES ('8', '1');
INSERT INTO `oa_manager_auth` VALUES ('9', '1');
INSERT INTO `oa_manager_auth` VALUES ('10', '4');

-- ----------------------------
-- Table structure for oa_manager_bank
-- ----------------------------
DROP TABLE IF EXISTS `oa_manager_bank`;
CREATE TABLE `oa_manager_bank` (
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `mobile` char(11) NOT NULL DEFAULT '' COMMENT '银行预留手机号',
  `card_num` varchar(30) NOT NULL DEFAULT '' COMMENT '银行卡号',
  `bank_name` varchar(50) NOT NULL DEFAULT '' COMMENT '开户银行',
  `card_name` varchar(20) NOT NULL DEFAULT '' COMMENT '持卡人',
  `province` varchar(20) NOT NULL DEFAULT '' COMMENT '开户省',
  `city` varchar(20) NOT NULL DEFAULT '' COMMENT '城市',
  `district` varchar(20) NOT NULL DEFAULT '' COMMENT '区',
  `branch` varchar(50) NOT NULL DEFAULT '' COMMENT '开户网点',
  `idcard_num` varchar(50) NOT NULL DEFAULT '' COMMENT '身份证号',
  `idcard_img` varchar(255) NOT NULL DEFAULT '' COMMENT '身份证图片',
  `is_type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '账户类型（1:银行卡,2:支付宝)',
  `alipay_account` varchar(50) NOT NULL DEFAULT '' COMMENT '支付宝帐号',
  `alipay_name` varchar(30) NOT NULL DEFAULT '' COMMENT '支付宝真实姓名',
  PRIMARY KEY (`manager_id`),
  KEY `manager_id` (`manager_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户银行信息表';

-- ----------------------------
-- Records of oa_manager_bank
-- ----------------------------
INSERT INTO `oa_manager_bank` VALUES ('2', '15936203633', '41152589663202556', '中原银行', '何璐', '上海市', '', '', '002123', '', '', '2', '15936203633', '徐磊');

-- ----------------------------
-- Table structure for oa_manager_honor
-- ----------------------------
DROP TABLE IF EXISTS `oa_manager_honor`;
CREATE TABLE `oa_manager_honor` (
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `honor_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '荣誉id',
  `use_honor_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '已用荣誉值',
  `current_honor_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '当前荣誉值',
  `total_honor_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '总荣誉值',
  PRIMARY KEY (`manager_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='员工荣誉表';

-- ----------------------------
-- Records of oa_manager_honor
-- ----------------------------
INSERT INTO `oa_manager_honor` VALUES ('2', '2', '1594', '8', '2502');
INSERT INTO `oa_manager_honor` VALUES ('5', '3', '0', '6060', '6060');
INSERT INTO `oa_manager_honor` VALUES ('7', '0', '0', '12', '12');
INSERT INTO `oa_manager_honor` VALUES ('8', '0', '0', '0', '0');
INSERT INTO `oa_manager_honor` VALUES ('9', '0', '0', '10', '10');
INSERT INTO `oa_manager_honor` VALUES ('10', '0', '0', '10', '10');

-- ----------------------------
-- Table structure for oa_manager_item
-- ----------------------------
DROP TABLE IF EXISTS `oa_manager_item`;
CREATE TABLE `oa_manager_item` (
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `department_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '部门id',
  PRIMARY KEY (`manager_id`),
  KEY `manager_id` (`manager_id`) USING BTREE,
  KEY `department_id` (`department_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='员工部门关联表';

-- ----------------------------
-- Records of oa_manager_item
-- ----------------------------
INSERT INTO `oa_manager_item` VALUES ('2', '2');
INSERT INTO `oa_manager_item` VALUES ('3', '2');
INSERT INTO `oa_manager_item` VALUES ('4', '2');
INSERT INTO `oa_manager_item` VALUES ('5', '2');
INSERT INTO `oa_manager_item` VALUES ('7', '2');
INSERT INTO `oa_manager_item` VALUES ('9', '3');
INSERT INTO `oa_manager_item` VALUES ('10', '4');
INSERT INTO `oa_manager_item` VALUES ('6', '6');
INSERT INTO `oa_manager_item` VALUES ('8', '6');

-- ----------------------------
-- Table structure for oa_manager_login
-- ----------------------------
DROP TABLE IF EXISTS `oa_manager_login`;
CREATE TABLE `oa_manager_login` (
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `login_num` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录次数',
  `login_ip` varchar(20) NOT NULL DEFAULT '' COMMENT '最后一次登录ip',
  `login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后一次登录时间',
  PRIMARY KEY (`manager_id`),
  KEY `manager_id` (`manager_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='登录信息表';

-- ----------------------------
-- Records of oa_manager_login
-- ----------------------------
INSERT INTO `oa_manager_login` VALUES ('1', '214', '58.218.188.202', '1617327942');
INSERT INTO `oa_manager_login` VALUES ('2', '121', '58.218.188.202', '1617269141');
INSERT INTO `oa_manager_login` VALUES ('3', '7', '58.218.188.202', '1617246916');
INSERT INTO `oa_manager_login` VALUES ('4', '7', '58.218.188.202', '1617248600');
INSERT INTO `oa_manager_login` VALUES ('5', '9', '58.218.188.202', '1617106896');
INSERT INTO `oa_manager_login` VALUES ('6', '3', '58.218.188.202', '1617087382');
INSERT INTO `oa_manager_login` VALUES ('7', '6', '58.218.188.202', '1617095233');
INSERT INTO `oa_manager_login` VALUES ('8', '2', '58.218.188.202', '1617096174');
INSERT INTO `oa_manager_login` VALUES ('9', '4', '58.218.188.202', '1617244421');
INSERT INTO `oa_manager_login` VALUES ('10', '12', '58.218.188.202', '1617263217');

-- ----------------------------
-- Table structure for oa_manager_login_log
-- ----------------------------
DROP TABLE IF EXISTS `oa_manager_login_log`;
CREATE TABLE `oa_manager_login_log` (
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `login_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '登录ip',
  `login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录时间',
  PRIMARY KEY (`manager_id`),
  KEY `manager_id` (`manager_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='员工登录记录 (多条)';

-- ----------------------------
-- Records of oa_manager_login_log
-- ----------------------------

-- ----------------------------
-- Table structure for oa_manager_platform
-- ----------------------------
DROP TABLE IF EXISTS `oa_manager_platform`;
CREATE TABLE `oa_manager_platform` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0',
  `platform_id` int(10) unsigned NOT NULL DEFAULT '0',
  `promote_account` varchar(20) NOT NULL DEFAULT '' COMMENT '推广员账号',
  `promote_password` varchar(30) NOT NULL DEFAULT '' COMMENT '推广员密码',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `register_last_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后拉取注册数据id',
  `recharge_last_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '充值数据最后拉取id',
  PRIMARY KEY (`id`),
  KEY `manager_id` (`manager_id`) USING BTREE,
  KEY `platform_id` (`platform_id`) USING BTREE,
  KEY `manager_id,platform_id` (`manager_id`,`platform_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COMMENT='员工推广员绑定表';

-- ----------------------------
-- Records of oa_manager_platform
-- ----------------------------
INSERT INTO `oa_manager_platform` VALUES ('1', '3', '7', 'ueMVzQRSmfzA', 'VHmQ0vo49XON', '1616812340', '1616812340', '0', '0');
INSERT INTO `oa_manager_platform` VALUES ('2', '2', '7', 'ceshi01', '123456', '1616812730', '1616812730', '22', '8');
INSERT INTO `oa_manager_platform` VALUES ('3', '4', '7', 'liudidi', '123456', '1616826796', '1616826796', '0', '0');
INSERT INTO `oa_manager_platform` VALUES ('5', '7', '7', 'JTsA3rkWtGkc', 'ZXq8jtz8j6H2', '1617016963', '1617016963', '20', '15');
INSERT INTO `oa_manager_platform` VALUES ('6', '8', '7', '5yAkXbCWKOYa', 'L10Guomeuazq', '1617093580', '1617093580', '24', '16');
INSERT INTO `oa_manager_platform` VALUES ('7', '9', '7', '3az9K40dIqrH', 'CFzdmk3qxPoL', '1617095447', '1617095447', '26', '17');
INSERT INTO `oa_manager_platform` VALUES ('10', '10', '7', 'OqFlaraXWCcd', 'zQ8zrpUqMGHp', '1617241158', '1617241158', '28', '18');
INSERT INTO `oa_manager_platform` VALUES ('11', '5', '7', 'ceshi02', '123456', '1617241828', '1617241828', '16', '7');

-- ----------------------------
-- Table structure for oa_notic
-- ----------------------------
DROP TABLE IF EXISTS `oa_notic`;
CREATE TABLE `oa_notic` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category` enum('falv','biaoyang','gonggao') NOT NULL DEFAULT 'gonggao' COMMENT '通知类型',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `description` varchar(200) NOT NULL DEFAULT '' COMMENT '描述',
  `content` text NOT NULL COMMENT '内容',
  `role_ids` varchar(20) NOT NULL DEFAULT '' COMMENT '可见角色ids',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束时间',
  `is_push` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否推送',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `push_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '推送状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='公告表';

-- ----------------------------
-- Records of oa_notic
-- ----------------------------
INSERT INTO `oa_notic` VALUES ('1', 'biaoyang', '优秀员工表扬', '积极灵活的工作方式，优秀的员工', '<p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">日落时分，<a href=\"https://www.59wz.com/zuowen/tiankong/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">天空</a>中抹过一片朝霞，<a href=\"https://www.59wz.com/zuowen/taiyang/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">太阳</a>快要落山了。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">夕阳西下，<a href=\"https://www.59wz.com/zuowen/taiyang/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">太阳</a>映照着整片街道，整个<a href=\"https://www.59wz.com/zuowen/shijie/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">世界</a>都变成了红色的了！当你抬头仰望，会看到一束红光照向你的面容，给人带来一丝向往之情。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">远处，一个小火球如同一颗跳动的心脏，它散发出耀眼的光芒，太阳要落山了！此时此刻，是一天中最美丽的时候。只见太阳一点儿一点儿的往下沉，最终，只剩下了半颗太阳，它犹如办个蛋黄，但比蛋黄神圣。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">红光四射，它将<a href=\"https://www.59wz.com/zuowen/ziji/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">自己</a>的光亮毫不留情地洒向大地。街道变红了，校园也变成红色的了，迎面走来的人们是红色的，整个<a href=\"https://www.59wz.com/zuowen/shijie/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">世界</a>都变成红色的了！</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">再看看远处的那颗大“火球”，它依然神圣，它代表着自由、活泼、<a href=\"https://www.59wz.com/zuowen/chenggong/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">成功</a>、<a href=\"https://www.59wz.com/zuowen/huanle/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">欢乐</a>、<a href=\"https://www.59wz.com/zuowen/yonggan/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">勇敢</a>……</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">这颗“火球”的颜色是最神圣的颜色，它常常使人心潮澎湃！</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\"><br/></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">此时此刻，仿佛整个世界都停止了，整个世界就都只剩下我与红光们，而我也仿佛与它们化为一体了！</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">渐渐地，太阳闪烁着它那跳动的火光消失了，但我依然沉浸在刚才的那一番情形中。我依然忘不了刚才那一番情形的辉煌、神圣、自由……</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">天彻底的黑了，我心里想着：不知道什么时候才能再回顾一次刚才那样的心潮澎湃呢？</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">日落美妙，它代表了前进、<a href=\"https://www.59wz.com/zuowen/yonggan/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">勇敢</a>，以及似海的前途！</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\"><img src=\"/Uploads/image/20210329/1617010294361522.jpg\" title=\"1617010294361522.jpg\" alt=\"猫咪.jpg\"/></p><p><br/></p>', '1', '0', '1616806800', '1617354000', '0', '1616806807', '1617243868', '1', '0');
INSERT INTO `oa_notic` VALUES ('2', 'gonggao', '致优秀的推广员们', '对优秀的推广们的表彰信', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">日落时分，<a href=\"https://www.59wz.com/zuowen/tiankong/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">天空</a>中抹过一片朝霞，<a href=\"https://www.59wz.com/zuowen/taiyang/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">太阳</a>快要落山了。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">夕阳西下，<a href=\"https://www.59wz.com/zuowen/taiyang/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">太阳</a>映照着整片街道，整个<a href=\"https://www.59wz.com/zuowen/shijie/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">世界</a>都变成了红色的了！当你抬头仰望，会看到一束红光照向你的面容，给人带来一丝向往之情。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">远处，一个小火球如同一颗跳动的心脏，它散发出耀眼的光芒，太阳要落山了！此时此刻，是一天中最美丽的时候。只见太阳一点儿一点儿的往下沉，最终，只剩下了半颗太阳，它犹如办个蛋黄，但比蛋黄神圣。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">红光四射，它将<a href=\"https://www.59wz.com/zuowen/ziji/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">自己</a>的光亮毫不留情地洒向大地。街道变红了，校园也变成红色的了，迎面走来的人们是红色的，整个<a href=\"https://www.59wz.com/zuowen/shijie/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">世界</a>都变成红色的了！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">再看看远处的那颗大“火球”，它依然神圣，它代表着自由、活泼、<a href=\"https://www.59wz.com/zuowen/chenggong/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">成功</a>、<a href=\"https://www.59wz.com/zuowen/huanle/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">欢乐</a>、<a href=\"https://www.59wz.com/zuowen/yonggan/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">勇敢</a>……</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">这颗“火球”的颜色是最神圣的颜色，它常常使人心潮澎湃！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">此时此刻，仿佛整个世界都停止了，整个世界就都只剩下我与红光们，而我也仿佛与它们化为一体了！</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">渐渐地，太阳闪烁着它那跳动的火光消失了，但我依然沉浸在刚才的那一番情形中。我依然忘不了刚才那一番情形的辉煌、神圣、自由……</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">天彻底的黑了，我心里想着：不知道什么时候才能再回顾一次刚才那样的心潮澎湃呢？</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(68, 68, 68); font-family: &quot;Microsoft YaHei&quot;; font-size: 14px; text-indent: 28px; white-space: normal;\">日落美妙，它代表了前进、<a href=\"https://www.59wz.com/zuowen/yonggan/\" target=\"_blank\" style=\"color: rgb(247, 9, 104);\">勇敢</a>，以及似海的前途！</p><p><br style=\"white-space: normal;\"/></p><p><br/></p>', '1', '0', '1616988600', '1617962400', '0', '1616988308', '1617244230', '1', '0');
INSERT INTO `oa_notic` VALUES ('3', 'gonggao', '优秀员工表扬4.1号', '只对上月优秀员工做统计', '<p>优秀员工统计</p><p><img src=\"/Uploads/image/20210401/1617244005296229.png\" title=\"1617244005296229.png\" alt=\"图片.png\"/></p><p>推广数量最多的到最少的依次排序</p><p><img src=\"/Uploads/image/20210401/1617244038941346.jpg\" title=\"1617244038941346.jpg\" alt=\"卡通.jpg\"/></p>', '0', '0', '1617244200', '1617969600', '0', '1617244086', '1617244086', '1', '0');

-- ----------------------------
-- Table structure for oa_option
-- ----------------------------
DROP TABLE IF EXISTS `oa_option`;
CREATE TABLE `oa_option` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `autoload` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '是否自动加载;1:自动加载;0:不自动加载',
  `option_name` varchar(64) NOT NULL DEFAULT '' COMMENT '配置名',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '配置值',
  PRIMARY KEY (`id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT COMMENT='全站配置表';

-- ----------------------------
-- Records of oa_option
-- ----------------------------

-- ----------------------------
-- Table structure for oa_platform
-- ----------------------------
DROP TABLE IF EXISTS `oa_platform`;
CREATE TABLE `oa_platform` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '平台名称',
  `appid` varchar(100) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT 'APPID',
  `ename` char(50) NOT NULL DEFAULT '' COMMENT '唯一标识',
  `api` text NOT NULL COMMENT '接口列表',
  `token` char(64) NOT NULL DEFAULT '' COMMENT 'token',
  `linkman` varchar(50) NOT NULL DEFAULT '' COMMENT '联系人',
  `tel` varchar(20) NOT NULL DEFAULT '' COMMENT '联系人电话',
  `creator_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建人编号',
  `creator` varchar(50) NOT NULL DEFAULT '' COMMENT '创建人',
  `create_type` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '创建方式(1:自主添加 2:系统对接)',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '-1:删除  0:禁用  1:正常',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='接入平台表';

-- ----------------------------
-- Records of oa_platform
-- ----------------------------

-- ----------------------------
-- Table structure for oa_recharge
-- ----------------------------
DROP TABLE IF EXISTS `oa_recharge`;
CREATE TABLE `oa_recharge` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `platform_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '平台id',
  `platform_order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '平台订单id',
  `game_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '游戏id',
  `game_name` varchar(100) NOT NULL DEFAULT '' COMMENT '游戏名称',
  `server_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '区服id',
  `server_name` varchar(100) NOT NULL DEFAULT '' COMMENT '区服名称',
  `user_account` varchar(100) NOT NULL DEFAULT '' COMMENT '用户账号',
  `player_name` varchar(100) NOT NULL DEFAULT '' COMMENT '角色名称',
  `promote_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '推广员id',
  `promote_account` varchar(100) NOT NULL DEFAULT '' COMMENT '推广员账号',
  `order_no` char(100) NOT NULL DEFAULT '' COMMENT '订单号',
  `cost_amount` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '实际支付金额',
  `total_amount` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单金额',
  `pay_ip` varchar(100) NOT NULL DEFAULT '' COMMENT '支付ip',
  `pay_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '充值时间',
  `pay_way` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '充值方式标识',
  `pay_way_str` varchar(100) NOT NULL DEFAULT '' COMMENT '充值方式(名称)',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `manager_id` (`manager_id`) USING BTREE,
  KEY `platform_id` (`platform_id`) USING BTREE,
  KEY `game_id` (`game_id`) USING BTREE,
  KEY `server_id` (`server_id`) USING BTREE,
  KEY `order_no` (`order_no`) USING BTREE,
  KEY `platform` (`platform_id`,`platform_order_id`) USING BTREE,
  KEY `manager_id,pay_time` (`manager_id`,`pay_time`),
  KEY `pay_time` (`pay_time`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of oa_recharge
-- ----------------------------
INSERT INTO `oa_recharge` VALUES ('1', '2', '7', '1', '6', '明星大侦探1VS1（H5游戏）', '1', '钢铁烈阳', 'xd123456', '我的亚索贼溜', '2', 'ceshi01', 'SP_20210327153517H1Iu', '100', '100', '58.218.188.202', '1616830517', '2', '平台币', '1616830621', '1616830621');
INSERT INTO `oa_recharge` VALUES ('2', '2', '7', '2', '1', '明星大侦探1VS1(安卓版)', '12', '江苏一区', 'xuceshi', '放学你别跑', '2', 'ceshi01', 'SP_20210329091931hxDX', '100', '100', '58.218.188.202', '1616980771', '2', '平台币', '1616980801', '1616980801');
INSERT INTO `oa_recharge` VALUES ('3', '2', '7', '3', '1', '明星大侦探1VS1(安卓版)', '12', '江苏一区', 'xudi12', '放学你别跑', '2', 'ceshi01', 'SP_20210329135343MCSz', '100000', '100000', '58.218.188.202', '1616997223', '1', '绑币', '1616997242', '1616997242');
INSERT INTO `oa_recharge` VALUES ('4', '5', '7', '5', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi2', '', '4', 'ceshi02', 'SP_202103291457208atJ', '3000', '3000', '58.218.188.202', '1617001043', '2', '平台币', '1617001141', '1617001141');
INSERT INTO `oa_recharge` VALUES ('5', '5', '7', '6', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi3', '', '4', 'ceshi02', 'SP_20210329154818BV1R', '150000', '150000', '58.218.188.202', '1617004103', '2', '平台币', '1617004381', '1617004381');
INSERT INTO `oa_recharge` VALUES ('6', '5', '7', '7', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi3', '', '4', 'ceshi02', 'SP_202103291550506Ntc', '150000', '150000', '58.218.188.202', '1617004253', '2', '平台币', '1617004381', '1617004381');
INSERT INTO `oa_recharge` VALUES ('7', '2', '7', '8', '1', '明星大侦探1VS1(安卓版)', '12', '江苏一区', 'ceshi4', '放学你别跑', '2', 'ceshi01', 'SP_20210329155650KGXy', '150000', '150000', '58.218.188.202', '1617004610', '1', '绑币', '1617004742', '1617004742');
INSERT INTO `oa_recharge` VALUES ('8', '7', '7', '12', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi5', '', '5', 'JTsA3rkWtGkc', 'SP_20210329193027jXHn', '300', '300', '114.234.196.130', '1617017430', '2', '平台币', '1617017581', '1617017581');
INSERT INTO `oa_recharge` VALUES ('9', '7', '7', '13', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi5', '', '5', 'JTsA3rkWtGkc', 'SP_20210329193503GIJB', '300', '300', '114.234.196.130', '1617017705', '2', '平台币', '1617017821', '1617017821');
INSERT INTO `oa_recharge` VALUES ('10', '7', '7', '14', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi5', '', '5', 'JTsA3rkWtGkc', 'SP_20210329200540BOnB', '300', '300', '114.234.196.130', '1617019542', '2', '平台币', '1617019621', '1617019621');
INSERT INTO `oa_recharge` VALUES ('11', '7', '7', '15', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi5', '', '5', 'JTsA3rkWtGkc', 'SP_20210329200549z1Ob', '300', '300', '114.234.196.130', '1617019552', '2', '平台币', '1617019621', '1617019621');
INSERT INTO `oa_recharge` VALUES ('12', '8', '7', '16', '1', '明星大侦探1VS1(安卓版)', '12', '江苏一区', 'yk_iTw32e', '放学你别跑', '6', '5yAkXbCWKOYa', 'SP_202103301648087qJ3', '1', '1', '114.234.196.130', '1617094088', '3', '支付宝', '1617094262', '1617094262');
INSERT INTO `oa_recharge` VALUES ('13', '9', '7', '17', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi7', '', '7', '3az9K40dIqrH', 'SP_202103302012173YBL', '1000', '1000', '114.234.196.130', '1617106341', '2', '平台币', '1617106501', '1617106501');
INSERT INTO `oa_recharge` VALUES ('14', '5', '7', '5', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi2', '', '4', 'ceshi02', 'SP_202103291457208atJ', '3000', '3000', '58.218.188.202', '1617001043', '2', '平台币', '1617241982', '1617241982');
INSERT INTO `oa_recharge` VALUES ('15', '5', '7', '6', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi3', '', '4', 'ceshi02', 'SP_20210329154818BV1R', '150000', '150000', '58.218.188.202', '1617004103', '2', '平台币', '1617241982', '1617241982');
INSERT INTO `oa_recharge` VALUES ('16', '5', '7', '7', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi3', '', '4', 'ceshi02', 'SP_202103291550506Ntc', '150000', '150000', '58.218.188.202', '1617004253', '2', '平台币', '1617241982', '1617241982');
INSERT INTO `oa_recharge` VALUES ('17', '10', '7', '18', '1', '明星大侦探1VS1(安卓版)', '12', '江苏一区', 'oaceshi', '放学你别跑', '10', 'OqFlaraXWCcd', 'SP_20210401112430tgCB', '1000', '1000', '114.234.196.130', '1617247470', '1', '绑币', '1617247621', '1617247621');

-- ----------------------------
-- Table structure for oa_register
-- ----------------------------
DROP TABLE IF EXISTS `oa_register`;
CREATE TABLE `oa_register` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `platform_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '平台id',
  `platform_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '平台用户id',
  `game_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '游戏id',
  `game_name` varchar(50) NOT NULL DEFAULT '' COMMENT '游戏名称',
  `server_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '区服id',
  `server_name` varchar(50) NOT NULL DEFAULT '' COMMENT '区服名称',
  `user_account` varchar(50) NOT NULL DEFAULT '' COMMENT '用户账号',
  `register_ip` varchar(50) NOT NULL DEFAULT '' COMMENT '注册ip',
  `device_no` varchar(50) NOT NULL DEFAULT '' COMMENT '设备码',
  `role_name` varchar(50) NOT NULL DEFAULT '' COMMENT '角色名',
  `register_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  `promote_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '推广员id',
  `promote_account` varchar(50) NOT NULL DEFAULT '' COMMENT '推广员名称',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`),
  KEY `manager_id` (`manager_id`) USING BTREE,
  KEY `platform_id` (`platform_id`) USING BTREE,
  KEY `game_id` (`game_id`) USING BTREE,
  KEY `server_id` (`server_id`) USING BTREE,
  KEY `platform` (`platform_id`,`platform_user_id`) USING BTREE,
  KEY `manager_id,register_time` (`manager_id`,`register_time`) USING BTREE,
  KEY `platform_id,manager_id,game_id,user_account,register_time` (`platform_id`,`manager_id`,`game_id`,`user_account`,`register_time`) USING BTREE,
  KEY `register_time` (`register_time`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of oa_register
-- ----------------------------
INSERT INTO `oa_register` VALUES ('1', '2', '7', '2', '4', '密室大逃脱（H5游戏）', '0', '', 'xd123456', '58.218.188.202', '', '', '1616823416', '2', 'ceshi01', '1616823481');
INSERT INTO `oa_register` VALUES ('2', '2', '7', '3', '5', '密室大逃脱（网页版）', '0', '', 'xuceshi1', '58.218.188.202', '', '', '1616824065', '2', 'ceshi01', '1616824142');
INSERT INTO `oa_register` VALUES ('3', '2', '7', '7', '1', '明星大侦探1VS1(安卓版)', '0', '', 'xuceshi', '58.218.188.202', '6dd19fc14008eddb', '', '1616980711', '2', 'ceshi01', '1616980861');
INSERT INTO `oa_register` VALUES ('4', '2', '7', '11', '5', '密室大逃脱（网页版）', '0', '', 'xudi12', '58.218.188.202', '', '', '1616989458', '2', 'ceshi01', '1616989621');
INSERT INTO `oa_register` VALUES ('5', '5', '7', '14', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi2', '58.218.188.202', '56F9314B-A797-42E7-ADA4-841B543B1832', '', '1617000792', '4', 'ceshi02', '1617000901');
INSERT INTO `oa_register` VALUES ('6', '5', '7', '16', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi3', '58.218.188.202', '56F9314B-A797-42E7-ADA4-841B543B1832', '', '1617001469', '4', 'ceshi02', '1617001622');
INSERT INTO `oa_register` VALUES ('7', '2', '7', '18', '1', '明星大侦探1VS1(安卓版)', '0', '', 'ceshi4', '112.65.61.161', '6dd19fc14008eddb', '', '1617001651', '2', 'ceshi01', '1617001741');
INSERT INTO `oa_register` VALUES ('8', '7', '7', '20', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi5', '114.234.196.130', '56F9314B-A797-42E7-ADA4-841B543B1832', '', '1617017313', '5', 'JTsA3rkWtGkc', '1617017461');
INSERT INTO `oa_register` VALUES ('9', '2', '7', '22', '1', '明星大侦探1VS1(安卓版)', '0', '', 'ceshi6', '58.218.188.202', '6dd19fc14008eddb', '', '1617069201', '2', 'ceshi01', '1617069302');
INSERT INTO `oa_register` VALUES ('10', '8', '7', '24', '1', '明星大侦探1VS1(安卓版)', '0', '', 'yk_iTw32e', '114.234.196.130', '868671035329100', '', '1617094021', '6', '5yAkXbCWKOYa', '1617094142');
INSERT INTO `oa_register` VALUES ('11', '9', '7', '26', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi7', '114.234.196.130', '56F9314B-A797-42E7-ADA4-841B543B1832', '', '1617106210', '7', '3az9K40dIqrH', '1617106381');
INSERT INTO `oa_register` VALUES ('12', '5', '7', '14', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi2', '58.218.188.202', '56F9314B-A797-42E7-ADA4-841B543B1832', '', '1617000792', '4', 'ceshi02', '1617241982');
INSERT INTO `oa_register` VALUES ('13', '5', '7', '16', '2', '明星大侦探1VS1(苹果版)', '0', '', 'ceshi3', '58.218.188.202', '56F9314B-A797-42E7-ADA4-841B543B1832', '', '1617001469', '4', 'ceshi02', '1617241982');
INSERT INTO `oa_register` VALUES ('14', '10', '7', '28', '1', '明星大侦探1VS1(安卓版)', '0', '', 'oaceshi', '114.234.196.130', '6dd19fc14008eddb', '', '1617247319', '10', 'OqFlaraXWCcd', '1617247382');

-- ----------------------------
-- Table structure for oa_role
-- ----------------------------
DROP TABLE IF EXISTS `oa_role`;
CREATE TABLE `oa_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '角色名称',
  `auth_ids` varchar(1000) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '角色权限',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '角色状态',
  `remark` varchar(200) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '角色备注',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Records of oa_role
-- ----------------------------
INSERT INTO `oa_role` VALUES ('1', '预备组长', '1,46,122,123,2,10,47,48,49,50,51,11,52,53,54,55,56,57,12,37,38,39,40,132,41,42,43,44,45,3,27,58,59,28,60,61,29,4,30,112,113,114,36,31,115,32,116,33,117,34,124,35,118,119,120,121,133,5,97,98,99,100,101,102,103,104,24,105,6,17,83,134,135,18,84,85,86,87,88,89,90,19,91,92,20,93,94,95,96,21,78,79,80,81,82,7,13,72,73,74,75,76,77,14,62,63,64,65,66,67,68,69,15,70,71,16,125,126,127,128,129,130,131,138,139,140,8,25,106,107,108,109,26,110,111', '1', '', '1616749654', '1617258896');
INSERT INTO `oa_role` VALUES ('2', '组长', '2,44,3,27,58,59,28,60,61,4,6,7,14,64', '1', '', '1616751374', '1616989278');
INSERT INTO `oa_role` VALUES ('3', '预备主管', '', '1', '', '1616826405', '1616826405');
INSERT INTO `oa_role` VALUES ('4', '主管', '1,46,122,123,2,10,47,48,49,50,51,136,137,11,52,53,54,55,56,57,12,37,38,39,40,132,41,42,43,44,45,3,27,58,59,28,60,61,29,4,30,112,113,114,36,31,115,32,116,33,117,34,124,35,118,119,120,121,133,5,22,97,98,99,100,23,101,102,103,104,24,105,6,17,83,134,135,18,84,85,86,87,88,89,90,19,91,92,20,93,94,95,96,21,78,79,80,81,82,7,13,72,73,74,75,76,77,14,62,63,64,65,66,67,68,69,15,70,71,16,125,126,127,128,129,130,131,8,25,106,107,108,109,26,110,111', '1', '', '1616826412', '1617247134');
INSERT INTO `oa_role` VALUES ('5', '预备经理', '', '1', '', '1616826426', '1616826426');
INSERT INTO `oa_role` VALUES ('6', '经理', '', '1', '', '1616826432', '1616826432');
INSERT INTO `oa_role` VALUES ('7', '人事', '', '1', '', '1616826440', '1616826440');
INSERT INTO `oa_role` VALUES ('8', '行政专员', '', '1', '', '1616826446', '1616826446');
INSERT INTO `oa_role` VALUES ('9', '优秀的推广员3级', '', '1', '', '1616826529', '1616826529');
INSERT INTO `oa_role` VALUES ('10', '普通员工', '', '0', '', '1617011614', '1617243351');
INSERT INTO `oa_role` VALUES ('11', '实习员工', '', '1', '', '1617011623', '1617011623');
INSERT INTO `oa_role` VALUES ('12', '实习生', '', '1', '', '1617095953', '1617095953');

-- ----------------------------
-- Table structure for oa_sms_log
-- ----------------------------
DROP TABLE IF EXISTS `oa_sms_log`;
CREATE TABLE `oa_sms_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template_id` varchar(30) NOT NULL DEFAULT '' COMMENT '短信模板',
  `phone` text NOT NULL,
  `content` varchar(255) NOT NULL,
  `expires_time` int(10) unsigned NOT NULL DEFAULT '0',
  `api_result` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0:未使用  1:已使用',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of oa_sms_log
-- ----------------------------

-- ----------------------------
-- Table structure for oa_upgrade
-- ----------------------------
DROP TABLE IF EXISTS `oa_upgrade`;
CREATE TABLE `oa_upgrade` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `version_name` varchar(20) NOT NULL DEFAULT '',
  `version_code` varchar(20) NOT NULL DEFAULT '',
  `content` varchar(255) NOT NULL DEFAULT '',
  `update_time` int(10) NOT NULL DEFAULT '0',
  `create_time` int(10) NOT NULL DEFAULT '0',
  `status` int(10) NOT NULL DEFAULT '0' COMMENT '0.待更新,1:更新成功,2:更新失败',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of oa_upgrade
-- ----------------------------

-- ----------------------------
-- Table structure for oa_wage_diy
-- ----------------------------
DROP TABLE IF EXISTS `oa_wage_diy`;
CREATE TABLE `oa_wage_diy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '角色id',
  `base_wage` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '基本工资',
  `grow_wage` int(10) NOT NULL DEFAULT '0' COMMENT '成长基金',
  `ratio` text NOT NULL COMMENT '流水提成比例',
  `bind_ratio` text NOT NULL,
  `elder_bonus` text NOT NULL COMMENT '元老奖励',
  `full_reward` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '全勤奖',
  `overtime_pay` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '加班费',
  `room` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '住房补贴',
  `food` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '餐补',
  `other` text NOT NULL COMMENT '其他',
  `elder_time` tinyint(2) unsigned NOT NULL DEFAULT '12',
  `statement_date` tinyint(1) unsigned NOT NULL DEFAULT '15' COMMENT '出账日期',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='自定义薪资表';

-- ----------------------------
-- Records of oa_wage_diy
-- ----------------------------
INSERT INTO `oa_wage_diy` VALUES ('1', '2', '300000', '20000', '[{\"max\":500000,\"ratio\":\"5\"},{\"max\":10000000,\"ratio\":\"10\"},{\"max\":20000000,\"ratio\":\"20\"},{\"max\":30000000,\"ratio\":\"40\"},{\"max\":50000000,\"ratio\":\"50\"}]', '', '', '30000', '50000', '20000', '30000', '[{\"title\":\"首付买房房补\",\"price\":10000000}]', '12', '5', '1616810908', '1617072144');
INSERT INTO `oa_wage_diy` VALUES ('2', '1', '300000', '20000', '[{\"max\":10000,\"ratio\":\"2\"},{\"max\":15000,\"ratio\":\"3\"},{\"max\":30000,\"ratio\":\"5\"}]', '', '[{\"max\":300000,\"bonus\":100000}]', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '12', '30', '1616815162', '1617072148');
INSERT INTO `oa_wage_diy` VALUES ('3', '3', '0', '0', '', '', '', '0', '0', '0', '0', '', '12', '15', '1617010101', '1617010101');

-- ----------------------------
-- Table structure for oa_wage_month
-- ----------------------------
DROP TABLE IF EXISTS `oa_wage_month`;
CREATE TABLE `oa_wage_month` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '员工id',
  `year` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '年',
  `month` tinyint(2) unsigned NOT NULL DEFAULT '0' COMMENT '月',
  `date_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '日期时间戳',
  `base_wage` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '基本工资',
  `grow_wage` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '成长基金',
  `elder_bonus` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '元老奖励',
  `full_reward` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '全勤奖',
  `overtime_pay` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '加班费',
  `room` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '住宿费',
  `food` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '餐费',
  `other` text NOT NULL COMMENT '其他',
  `recharge` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '消费提成',
  `total_salary` int(10) NOT NULL DEFAULT '0' COMMENT '工资',
  `send_manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发放人id',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态(0: 未发放 1: 已发放)',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `manager_id` (`manager_id`) USING BTREE,
  KEY `month` (`year`,`month`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of oa_wage_month
-- ----------------------------
INSERT INTO `oa_wage_month` VALUES ('8', '2', '2021', '3', '1614528000', '300000', '20000', '0', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '12510', '482510', '1', '2', '1617072914', '1617073989');
INSERT INTO `oa_wage_month` VALUES ('9', '4', '2021', '3', '1614528000', '300000', '20000', '30000', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '0', '500000', '0', '0', '1617072914', '1617074435');
INSERT INTO `oa_wage_month` VALUES ('10', '5', '2021', '3', '1614528000', '300100', '20100', '100100', '30100', '50100', '20100', '30100', '[{\"title\":\"房补\",\"price\":20100}]', '15150', '585950', '1', '2', '1617072914', '1617073184');
INSERT INTO `oa_wage_month` VALUES ('11', '6', '2021', '3', '1614528000', '300000', '20000', '0', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '0', '470000', '1', '2', '1617072914', '1617073165');
INSERT INTO `oa_wage_month` VALUES ('12', '7', '2021', '3', '1614528000', '300000', '20000', '0', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '0', '470000', '0', '2', '1617072914', '1617073007');
INSERT INTO `oa_wage_month` VALUES ('13', '2', '2021', '2', '1612108800', '300000', '20000', '0', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '0', '470000', '0', '0', '1617074960', '1617257384');
INSERT INTO `oa_wage_month` VALUES ('14', '4', '2021', '2', '1612108800', '300000', '20000', '0', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '0', '470000', '0', '0', '1617074960', '1617074960');
INSERT INTO `oa_wage_month` VALUES ('15', '5', '2021', '2', '1612108800', '300000', '50010', '70000', '30000', '80000', '0', '30000', '[{\"title\":\"房补\",\"price\":50000}]', '0', '610010', '0', '0', '1617074960', '1617258205');
INSERT INTO `oa_wage_month` VALUES ('16', '6', '2021', '2', '1612108800', '300000', '20000', '0', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '0', '470000', '0', '0', '1617074960', '1617074960');
INSERT INTO `oa_wage_month` VALUES ('17', '7', '2021', '2', '1612108800', '500000', '20000', '0', '30000', '50000', '20000', '30000', '[{\"title\":\"房补\",\"price\":20000}]', '0', '670000', '1', '1', '1617074960', '1617102468');

-- ----------------------------
-- Table structure for oa_welfare
-- ----------------------------
DROP TABLE IF EXISTS `oa_welfare`;
CREATE TABLE `oa_welfare` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '福利名称',
  `required` varchar(50) NOT NULL COMMENT '指标',
  `start_time` int(10) NOT NULL DEFAULT '0',
  `end_time` int(10) NOT NULL DEFAULT '0',
  `create_time` int(10) NOT NULL DEFAULT '0',
  `update_time` int(10) NOT NULL DEFAULT '0',
  `manager_id` int(10) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='福利表';

-- ----------------------------
-- Records of oa_welfare
-- ----------------------------
INSERT INTO `oa_welfare` VALUES ('1', '5元无门槛优惠券', '20', '1616803200', '1617148800', '1616808258', '1616808258', '1', '-1');
INSERT INTO `oa_welfare` VALUES ('2', '50元现金红包', '单日业绩超过1000', '1616803200', '1618617600', '1616808334', '1617247621', '10', '1');
INSERT INTO `oa_welfare` VALUES ('3', '12', '120', '1614643200', '1617148800', '1617020960', '1617020960', '2', '-1');
INSERT INTO `oa_welfare` VALUES ('4', '无门槛小福利', '15', '1617235200', '1619740800', '1617247601', '1617247649', '10', '1');
