import axios from "@/api/base.js";
export default {
    /**
     * 业绩总览相关
     */
    getDataSumList: data => {
        return axios.post('admin/data/summarize', data)
    },
    getDataSummnyList: data => {
        return axios.post('admin/achievements/overview', data)
    },
    getRightFixedList: data => {
        return axios.post('admin/achievements/department', data)
    },
    getDataSummnyHeader: data => {
        return axios.post('admin/achievements/data', data)
    },
    /**
     * 工资表相关
     */
    getWageManager: data => {
        return axios.post('admin/wage/manager', data)
    },
    getStaffPay: data => {
        return axios.post('admin/wage/lists', data)
    },
    sendWageInfo: data => {
        return axios.post('admin/wage/send', data)
    },
    saveStaffPayInfo: data => {
        return axios.post('admin/wage/update', data)
    },
    sendMessage: data => {
        return axios.post('admin/wage/message', data)
    },
    downWageExcel: data => {
        return axios.get('admin/wage/exportExcel', { params: data })
    },
    /**
     * 今日业绩相关
     */
    getDataEarning: data => {
        return axios.post('admin/achievements/overviewDetail', data)
    },
    /**
     * 公告通知相关
     */
    getDataNewsInfo: data => {
        return axios.post('admin/notic/studioNotic', data)
    },
    /**
     * 修改密码相关
     */
    updataPassword: data => {
        return axios.post('admin/manager/modifypassword', data)
    },
    /**
     * 数据汇总
     */
    getDataSumList: data => {
        return axios.post('admin/data/summarize', data)
    },
    getDataregisterDetail: data => {
        return axios.post('admin/data/viewRegister', data)
    },
    getDataMoneySumDetail: data => {
        return axios.post('admin/data/viewRecharge', data)
    },

    /**
     * 充值明细
     */
    getDataRechargeList: data => {
        return axios.post('admin/data/recharge', data)
    },
    /**
     * 注册明细
     */
    getDataRegisterList: data => {
        return axios.post('admin/data/register', data)
    },
    /**
     * 排行榜相关
     */
    getTheDayList: data => {
        return axios.post('admin/rank/yesterday', data)
    },
    getRankDayList:data => {
        return axios.post('admin/rank/day', data)
    },
    getTheWeekList: data => {
        return axios.post('admin/rank/week', data)
    },
    getTheMonthList: data => {
        return axios.post('admin/rank/month', data)
    },
    getTheQuarterList: data => {
        return axios.post('admin/rank/season', data)
    },

    getOverviewData: data => {
      return axios.post('admin/index/home_data', data)
    },
     /**
     * 首页游戏相关
     */
    getIndexGame: data => {
        return axios.post('admin/index/recommendGame', data)
    },
     /**
     * 首页游戏记录点击数
     */
    setClickGameNum: data => {
        return axios.post('admin/index/clickGame', data)
    },
};