import axios from "@/api/base.js";

export default {
    /**
     * 荣誉设置相关
     */
    getHonorSetInfo: data => {
        return axios.post('admin/honor/lists', data)
    },
    getHonorSetRatio: data => {
        return axios.post('admin/honor/getRatio', data)
    },
    setHonorSetRatio: data => {
        return axios.post('admin/honor/setRatio', data)
    },
    addHonorSetInfo: data => {
        return axios.post('admin/honor/create', data)
    },
    editHonorSetInfo: data => {
        return axios.post('admin/honor/update', data)
    },
    deleteHonorSetInfo: data => {
        return axios.post('admin/honor/delete', data)
    },
    getHonorInfoDetail: data => {
        return axios.post('admin/honor/detail', data)
    },
    changeCurindexHonor: data => {
        return axios.post('admin/channel/modHonorNum', data)
    },
    /**
     * 荣誉查看相关
     */
    getHonorLookInfo: data => {
        return axios.post('admin/honor/managerHonor', data)
    },
    sendSms: data => {
        return axios.post('admin/honor/sendSms', data)
    },
    getShowManagerRecord: data => {
        return axios.post('admin/Honor_apply/showManagerRecord', data)
    },
    /**
     * 我的荣誉相关
     */

    /**
     * 特权申请相关
     */
    getApplyPower: data => {
        return axios.post('admin/Honor_apply/lists', data)
    },
    applePower: data => {
        return axios.post('admin/Honor_apply/doApply', data)
    },
    /**
     * 特权审核相关
     */
    getPowerAudit: data => {
        return axios.post('admin/Honor_apply/applyRecord', data)
    },
    passPowerAudit: data => {
        return axios.post('admin/Honor_apply/pass', data)
    },
    rejectPowerAudit: data => {
        return axios.post('admin/Honor_apply/reject', data)
    },
    grantPowerAudit: data => {
        return axios.post('admin/Honor_apply/grant', data)
    },
    sendTextPowerAudit: data => {
        return axios.post('admin/Honor_apply/sendSms', data)
    },
    /**
     * 我的福利
     */
    getHonorWelfare: data => {
        return axios.post('admin/welfare/lists', data)
    },
    addHonorWelfare: data => {
        return axios.post('admin/welfare/create', data)
    },
    getHonorWelfareDetail: data => {
        return axios.post('admin/welfare/detail', data)
    },
    editHonorWelfare: data => {
        return axios.post('admin/welfare/update', data)
    },
    deleteHonorWelfare: data => {
        return axios.post('admin/welfare/delete', data)
    },
    /**
     * 后台首页
     */
    getHonorIndex: data => {
        return axios.post('admin/index/homePage', data)
    },
    setUserAvatar: data => {
        return axios.post('admin/manager/modifyavatar', data)
    },
};