import axios from "@/api/base.js";

export default {
    /**
     * 团队列表相关
     */
    getTeamList: data => {
        return axios.post('admin/department/lists', data);
    },
    getTeamSelectList: data => {
        return axios.post('admin/department/selectList', data)
    },
    addTeamList: data => {
        return axios.post('admin/department/create', data)
    },
    getTeamListDetail: data => {
        return axios.post('admin/department/detail', data)
    },
    editTeamList: data => {
        return axios.post('admin/department/update', data)
    },
    updateLegionName: data => {
        return axios.post('admin/department/modifyStudioName', data)
    },
    disableTeamStatus: data => {
        return axios.post('admin/department/disable', data)
    },
    enableTeamStatus: data => {
        return axios.post('admin/department/enable', data)
    },
    getDepartmentTreeSelect: data => {
        return axios.post('admin/department/treeSelect', data)
    },
    /**
     * 员工相关
     */
    getStaffList: data => {
        return axios.post('admin/Staff/lists', data)
    },
    getStaffDetail: data => {
        return axios.post('admin/Staff/detail', data)
    },
    addStaffList: data => {
        return axios.post('admin/Staff/create', data)
    },
    editStaffList: data => {
        return axios.post('admin/Staff/update', data)
    },
    enableStaffList: data => {
        return axios.post('admin/Staff/enable', data)
    },
    disableStaffList: data => {
        return axios.post('admin/Staff/disable', data)
    },
    deleteStaffList: data => {
        return axios.post('admin/Staff/delete', data)
    },
    getStaffSelectList: data => {
        return axios.post('admin/Staff/select_lists', data)
    },
    /**
     * 推广员绑定平台相关
     */
    getStaffChannel: data => {
        return axios.post('admin/channel/lists', data)
    },
    addStaffChannel: data => {
        return axios.post('admin/channel/create', data)
    },
    getStaffChannelDetail: data => {
        return axios.post('admin/channel/detail', data)
    },
    editStaffChannel: data => {
        return axios.post('admin/channel/update', data)
    },
    deleteStaffChannel: data => {
        return axios.post('admin/channel/delete', data)
    },
    getStudioChannel: data => {
        return axios.post('admin/channel/studioChannel', data)
    },
    getPlatformSelectList: data => {
        return axios.post('admin/platform/selectLists', data)
    },
    getPlatformStudioList: data => {
        return axios.post('admin/platform/studioLists', data)
    },
    uploadChannelTpl: data => {
        return axios.post('admin/upload/uploadChannelTpl', data)
    },
    moreSaveChannelInfo: data => {
        return axios.post('admin/channel/batchCreate', data)
    },
    /**
     * 工资结算表相关
     */

};