/**
 * 路由信息
 */

import Vue from 'vue'
import Router from 'vue-router'
import user from '@/router/user/user_router'
import set from '@/router/set/set_router'
import staff from '@/router/staff/staff_router'
import data from '@/router/data/data_router'
import honor from '@/router/honor/honor_router'
import finance from '@/router/finance/finance'
import platform from '@/router/platform/platform'
import game from '@/router/game/game'
Vue.use(Router)

const manage = () => import('@/pages/manage')
const index = () => import('@/pages/base/index')
const login = () => import('@/pages/base/login')
const err404 = () => import('@/pages/base/err_404')
const extension = () => import('@/pages/extension/extension')
export default new Router({
  routes: [
    {
      path: '/err_404',
      name: 'err_404',
      component: err404,
      meta: { reqAuth: '0123' }
    },
    {
      path: '/login',
      name: 'login',
      component: login,
    },
    {
      path: '/',
      name: 'manage',
      component: manage,
      redirect: '/index',
      meta: { reqAuth: '0123' },
      children: [
        ...user,
        ...set,
        ...data,
        ...staff,
        ...honor,
        ...finance,
        ...platform,
        ...game,
        {
          path: 'extension',
          component: extension,
          name: 'extension',
          meta: { reqAuth: '020', Btype: 0, Stype: "extension" }
        },
        {
          path: '/index',
          component: index,
          name: 'index',
          meta: { reqAuth: '0123', Btype: 0, Stype: "index" }
        }
      ]
    }
  ]
})
