/**
 * *状态管理 Actions
 */

import api from '@/api'
import { Message } from 'iview'
import router from '@/router'
import store from '@/store/index'
import { getStore, setStore, removeStore } from "@/utils/utils";
const actions = {
    updateUserInfo({ commit }) {
        let userInfo = getStore('userInfo')
        commit('userInfo', userInfo)
    },
    logout({ commit, state, dispatch }) {
        api.logout().then(data => {
            if (data.code === 200) {
                store.commit("resetData", "adminInfo");
                removeStore("userInfo");
                router.push({ path: "/login" });
            }
        })
    },
    getLogoIcoInfo({ commit, state, dispatch }) {
        api.getSiteInfo().then(data => {
            if (data.code == 200) {
                setStore('logoIco',{logo:data.data.admin_logo_url,ico:data.data.admin_icon_url})
            }
        })
    },
    setOneDayCookie({ commit, state, dispatch }) {
        var curDate = new Date();
        //当前时间戳
        var curTamp = curDate.getTime();
        //当日凌晨的时间戳,减去一毫秒是为了防止后续得到的时间不会达到00:00:00的状态
        var curWeeHours = new Date(curDate.toLocaleDateString()).getTime() - 1;
        //当日已经过去的时间（毫秒）
        var passedTamp = curTamp - curWeeHours;
        //当日剩余时间
        var leftTamp = 24 * 60 * 60 * 1000 - passedTamp;
        var leftTime = new Date();
        leftTime.setTime(leftTamp + curTamp);
        //创建cookie
        document.cookie = state.adminInfo.nickname+'=first' + ";expires=" + leftTime.toGMTString();
    },
}

export default actions
