/**
 * *状态管理 Mutations
 */

const mutations = {
  /**
   * *统一改变值
   * @param {String} data.type state中的类型
   * @param {String} data.stype type类型中的类型
   * @param {any} data.value 修改的值
   */
  changeValue(state, { type, value, stype }) {
    if (stype) {
      state[type][stype] = value;
    } else {
      state[type] = value;
    }
  },
  userInfo(state, data) {
    for (let it in data) {
      state.adminInfo[it] = data[it];
    }
  },
  changeloading(state, data) {
    state.loading=data
  },
  changeisShowRightNav(state, data) {
    state.isShowRightNav=data
  },
  changeFirstLogin(state, data) {
    state.isFirstLogin=data
  },
  // 重置State数据
  resetData(state, data) {
    for (let i in state[data]) {
      state[data][i] = "";
    }
  },
  /**
  * *改变路由
  * @param {Number} routeType 顶部类型
  * @param {String} activeSubmenu 左边 菜单组名
  * @param {String} activeMenuItem 左边 菜单名
  */
  changeSaveRoute(state, { routeType, activeSubmenu, activeMenuItem }) {
    if (routeType || routeType === 0) {
      state.routeType = routeType;
    }
    if (activeSubmenu) {
      state.saveRoute[state.routeType].activeSubmenu = activeSubmenu;
    }
    if (activeMenuItem || activeMenuItem === "") {
      state.saveRoute[state.routeType].activeMenuItem = activeMenuItem;
    }
  }
};

export default mutations;
