/**
 * *工具函数
 */
import { Base64 } from 'js-base64'
/**
 * 存储localStorage
 * @param {name} 储存名字
 * @param {content} 储存内容
 */
export const setStore = (name, content) => {
  if (!name) return
  if (typeof content !== 'string') {
    content = JSON.stringify(content)
  }
  window.localStorage.setItem(name, content)
}

/**
 * 获取localStorage
 * @param {name} 储存名字
 */
export const getStore = name => {
  if (!name) return
  let content = window.localStorage.getItem(name)
  return JSON.parse(content) || ''
}

// 通过cookie判断是否首次登录
export const isFirstLogin = (name) => {
  let coArr = []
  let current
  let cookie = document.cookie ? document.cookie.split(';') : []
  if (!!!cookie.length) {
      return false
  } else {
      cookie.forEach((item, index) => {
          coArr[index] = item.split('=')
      })
      current = coArr.filter((item, index) => {
        if(item[0].indexOf(name)!==-1){
          return name
        }
      })
      if (current.length) {
          return decodeURIComponent(current[0][0])
      } else {
          return ''
      }
  }
}

/**
 * 删除localStorage
 * @param {name} 储存名字
 */
export const removeStore = name => {
  if (!name) return
  // name = Base64.encode(name)
  window.localStorage.removeItem(name)
}

/**
 * 设置浏览器标签名
 * !暂时没用到
 * @param {String} title 标签名
 */
export const setTitle = title => {
  title = title
  window.document.title = title
}
/**
 * 设置cookie
 * @param {String} cname 名称
 * @param {String} cvalue 值
 * @param {String} exdays 保存时间
 */
export const setCookie = (cname, cvalue, exdays) => {
  var d = new Date()
  d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000))
  var expires = 'expires=' + d.toUTCString()
  document.cookie = cname + '=' + cvalue + '; ' + expires
}

/**
 * 过滤函数 数组
 * @param {Array}
 * @param {Array}
 * @return {Array}
 */
export const filterArray = (oldArr, selectArr) => {
  if (!oldArr.length) return false
  let newArr = oldArr.filter((it, ix) => {
    let hasFlag
    selectArr.some((itm, idx) => {
      let id = it.id || it.ids
      if (id === itm) {
        hasFlag = false
        return true
      } else {
        hasFlag = true
        return false
      }
    })
    if (hasFlag) {
      return true
    } else {
      return false
    }
  })
  return newArr
}

/**
 * 定长随机字符串
 * @param {number} len 字符串长度
 * @param {boolean} flag 是否去掉易混淆字符
 */
export const randomString = (len = 32, flag = false) => {
  const chars = flag?'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678':'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'
  const max = chars.length
  let temp = ''
  for (let i = 0; i < len; i++) {
    temp += chars.charAt(Math.floor(Math.random() * max))
  }
  return temp
}

/**
 * 不定长随机字符串
 * @param {boolean} flag 是否去掉易混淆字符
 * @param {number} bit 长度位数(默认最大3位数的长度)
 */
export const randomStringUndefinedLength = (flag = false, bit = 3) => {
  const len = Math.floor(Math.random() * Math.pow(10, bit - 1))
  return randomString(len < 1 ? 1 : len, flag)
}

/**
 * 时间格式化
 * @param {Object|string|number} time
 * @param {string} format
 */
 export function timeFormatter (time, format) {
  if (arguments.length === 0 || !time) {
    return null
  }
  format = format || '{y}-{m}-{d} {h}:{i}:{s}'
  let date
  if (typeof time === 'object') {
    date = time
  } else {
    if ((typeof time === 'string')) {
      if ((/^[0-9]+$/.test(time))) {
        time = parseInt(time)
      } else {
        time = time.replace(new RegExp(/-/gm), '/')
      }
    }

    if ((typeof time === 'number') && (time.toString().length === 10)) {
      time = time * 1000
    }
    date = new Date(time)
  }
  const formatObj = {
    y: date.getFullYear(),
    m: date.getMonth() + 1,
    d: date.getDate(),
    h: date.getHours(),
    i: date.getMinutes(),
    s: date.getSeconds(),
    a: date.getDay()
  }
  const timeStr = format.replace(/{([ymdhisa])+}/g, (result, key) => {
    const value = formatObj[key]
    if (key === 'a') { return ['日', '一', '二', '三', '四', '五', '六'][value] }
    return value.toString().padStart(2, '0')
  })
  return timeStr
}

