/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.interfaces;

import org.xvolks.jnative.Native;
import org.xvolks.jnative.com.utils.Logger;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.util.windows.structures.GUID;

public abstract class IUnknown
implements Runnable {
    public static final GUID IIDIUnknown = new GUID("{00000000-0000-0000-C000-000000000046}");
    @Native
    private int pIDispatch;
    @Native
    private int hWnd;
    @Native
    private int ownerThreadId;
    private final String iid;
    private final String progId;
    private final Logger logger;
    private final Thread iDispatchThread = new Thread(this);
    private Object initedLock = new Object();
    private boolean disposed = false;
    private boolean messagePumpingStarted = false;
    private Object loopMutex = new Object();
    private Throwable initThrowable = null;

    protected IUnknown(String progId, String iid, int hWnd, int ownerThreadId) throws Throwable {
        this(progId, iid, hWnd, ownerThreadId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IUnknown(String progId, String iid, int hWnd, int ownerThreadId, int iUnknown) throws Throwable {
        this.progId = progId;
        this.iid = iid;
        this.hWnd = hWnd;
        this.ownerThreadId = ownerThreadId;
        this.pIDispatch = iUnknown;
        this.logger = Logger.getInstance(this.getClass().getSimpleName());
        Object object = this.initedLock;
        synchronized (object) {
            try {
                this.logger.debug("Starting IDispatch thread");
                this.iDispatchThread.start();
                this.initedLock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.initThrowable != null) {
            throw this.initThrowable;
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getPIDispatch() {
        return this.pIDispatch;
    }

    @Native
    private void setPIDispatch(int dispatch) {
        this.pIDispatch = dispatch;
    }

    @Native
    private void setHWnd(int wnd) {
        this.hWnd = wnd;
    }

    protected int getHWnd() {
        return this.hWnd;
    }

    protected int getOwnerThreadId() {
        return this.ownerThreadId;
    }

    @Native
    private void setOwnerThreadId(int ownerThreadId) {
        this.ownerThreadId = ownerThreadId;
    }

    public long addRef() throws NativeException {
        return this.AddRef();
    }

    public long release() throws NativeException {
        return this.Release();
    }

    public LONG queryInteface(GUID refId) throws NativeException {
        LONG vObject = new LONG(0);
        if (this.QueryInterface(refId, vObject.getPointer().getPointer())) {
            return vObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.progId == null || this.iid == null) {
            this.initThrowable = new NullPointerException("progId AND iid cannot be null !!!");
        } else {
            try {
                this.comNewInstance(this.progId, this.iid);
            }
            catch (Throwable t) {
                this.initThrowable = t;
            }
        }
        Object object = this.initedLock;
        synchronized (object) {
            this.initedLock.notify();
        }
        if (this.initThrowable == null) {
            this.doMessagePump();
        }
    }

    protected abstract void beforeMessagePump();

    protected abstract void afterMessagePump();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doMessagePump() {
        block16: {
            if (this.progId == null || this.iid == null) {
                return;
            }
            boolean doLoop = false;
            Object object = this.loopMutex;
            synchronized (object) {
                if (!this.messagePumpingStarted) {
                    this.messagePumpingStarted = true;
                    doLoop = true;
                }
            }
            if (doLoop) {
                try {
                    this.beforeMessagePump();
                }
                catch (Throwable t) {
                    this.logger.error("Error in beforeMessagePump(). Exiting IDispatch Thread.", t);
                    return;
                }
                this.comDoMessagePump();
                Object var5_6 = null;
                try {
                    this.afterMessagePump();
                }
                catch (Throwable t2) {
                    this.logger.warn("Error in afterMessagePump().", t2);
                }
                break block16;
                {
                    catch (Throwable t) {
                        this.logger.error("Error in message pumping native loop", t);
                        Object var5_7 = null;
                        try {
                            this.afterMessagePump();
                        }
                        catch (Throwable t2) {
                            this.logger.warn("Error in afterMessagePump().", t2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        this.afterMessagePump();
                    }
                    catch (Throwable t2) {
                        this.logger.warn("Error in afterMessagePump().", t2);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected synchronized void exitMessagePump() {
        if (this.progId == null || this.iid == null) {
            return;
        }
        if (this.messagePumpingStarted) {
            this.comExitMessagePump();
            this.messagePumpingStarted = false;
        }
    }

    public synchronized void dispose() {
        if (this.progId == null || this.iid == null) {
            return;
        }
        if (!this.disposed) {
            this.comDispose();
            this.exitMessagePump();
            this.disposed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private native void comNewInstance(String var1, String var2);

    private native void comDispose();

    private native void comDoMessagePump();

    private native void comExitMessagePump();

    private native long AddRef() throws NativeException;

    private native long Release() throws NativeException;

    private native boolean QueryInterface(GUID var1, int var2) throws NativeException;
}

