/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util;

import java.util.List;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.Type;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.IP_ADAPTER_INFO;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iphlpapi {
    public static final String DLL_NAME = "Iphlpapi.dll";

    public static List<IP_ADAPTER_INFO> GetAdaptersInfo(int maxAdapters) throws NativeException, IllegalAccessException {
        JNative GetAdaptersInfo = new JNative(DLL_NAME, "GetAdaptersInfo");
        GetAdaptersInfo.setRetVal(Type.INT);
        if (maxAdapters < 1) {
            return null;
        }
        Pointer p = IP_ADAPTER_INFO.reserveMemoryOf_IP_ADAPTER_INFO(maxAdapters);
        GetAdaptersInfo.setParameter(0, p);
        LONG pOutBufLen = new LONG(p.getSize());
        GetAdaptersInfo.setParameter(1, pOutBufLen.getPointer());
        GetAdaptersInfo.invoke();
        int ret = GetAdaptersInfo.getRetValAsInt();
        Error error = Error.fromInt(ret);
        switch (error) {
            case ERROR_SUCCESS: {
                break;
            }
            case ERROR_BUFFER_OVERFLOW: {
                throw new NativeException(error.toString() + ". need a buffer of _" + pOutBufLen.getValue() + "Bytes");
            }
            case ERROR_INVALID_DATA: {
                throw new NativeException(error.toString() + ". Invalid adapter information was retrieved.");
            }
            case ERROR_INVALID_PARAMETER: {
                throw new NativeException(error.toString() + ". One of the parameters is invalid. This error is returned if the pOutBufLen parameter is a NULL pointer, or the calling process does not have read/write access to the memory pointed to by pOutBufLen or the calling process does not have write access to the memory pointed to by the pAdapterInfo parameter.");
            }
            case ERROR_NO_DATA: {
                throw new NativeException(error.toString() + ". No adapter information exists for the local computer.");
            }
            case ERROR_NOT_SUPPORTED: {
                throw new RuntimeException(error.toString() + ". The GetAdaptersInfo function is not supported by the operating system running on the local computer.");
            }
            default: {
                System.err.println("Unknown return code " + pOutBufLen.getValue() + "  " + p.getSize());
                throw new RuntimeException("Unknown return code " + ret);
            }
        }
        if (pOutBufLen.getValue().intValue() != p.getSize()) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.WARN, "GetAdaptersInfo : Not enougth size ?");
        }
        return IP_ADAPTER_INFO.getListOf_IP_ADAPTER_INFO(p);
    }

    public static void main(String[] args) throws NativeException, IllegalAccessException {
        List<IP_ADAPTER_INFO> infos = Iphlpapi.GetAdaptersInfo(64);
        System.err.println("Module " + JNative.getCurrentModule());
        for (IP_ADAPTER_INFO info : infos) {
            System.err.println("info " + info.getAdapterName() + " - " + info.getDescription() + " : " + info.getAddressAsUnixFormat() + " et " + info.getAddressAsWindowsFormat() + " ip address is " + info.getIpAddressList().getIpAddress());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error {
        ERROR_SUCCESS(0),
        ERROR_BUFFER_OVERFLOW(111),
        ERROR_INVALID_DATA(13),
        ERROR_INVALID_PARAMETER(87),
        ERROR_NO_DATA(232),
        ERROR_NOT_SUPPORTED(50);

        private final int value;

        private Error(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Error fromInt(int value) {
            for (Error err : Error.values()) {
                if (err.getValue() != value) continue;
                return err;
            }
            throw new IllegalArgumentException(value + " is not correct !");
        }
    }
}

