/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.mapi.structs;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.AbstractBasicData;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapiMessage
extends AbstractBasicData<MapiMessage> {
    public LONG ulReserved = new LONG(0);
    public int lpszSubject;
    public int lpszNoteText;
    public int lpszMessageType;
    public int lpszDateReceived;
    public int lpszConversationID;
    public int flFlags;
    public int lpOriginator;
    public LONG nRecipCount = new LONG(0);
    public int lpRecips;
    public LONG nFileCount = new LONG(0);
    public int lpFiles;

    public MapiMessage() throws NativeException {
        super(null);
        this.createPointer();
    }

    public MapiMessage(int nativeAddress) throws NativeException {
        this();
        this.pointer.setMemory(JNative.getMemory(nativeAddress, MapiMessage.sizeOf()));
        this.getValueFromPointer();
    }

    @Override
    public MapiMessage getValue() {
        return this;
    }

    @Override
    public MapiMessage getValueFromPointer() throws NativeException {
        this.offset = 0;
        this.ulReserved = new LONG(this.getNextInt());
        this.lpszSubject = this.getNextInt();
        this.lpszNoteText = this.getNextInt();
        this.lpszMessageType = this.getNextInt();
        this.lpszDateReceived = this.getNextInt();
        this.lpszConversationID = this.getNextInt();
        this.flFlags = this.getNextInt();
        this.lpOriginator = this.getNextInt();
        this.nRecipCount = new LONG(this.getNextInt());
        this.lpRecips = this.getNextInt();
        this.nFileCount = new LONG(this.getNextInt());
        this.lpFiles = this.getNextInt();
        this.offset = 0;
        return this;
    }

    @Override
    public Pointer createPointer() throws NativeException {
        if (this.pointer != null) {
            int i = -4;
            this.pointer.setIntAt(i += 4, this.ulReserved.getValue());
            this.pointer.setIntAt(i += 4, this.lpszSubject);
            this.pointer.setIntAt(i += 4, this.lpszNoteText);
            this.pointer.setIntAt(i += 4, this.lpszMessageType);
            this.pointer.setIntAt(i += 4, this.lpszDateReceived);
            this.pointer.setIntAt(i += 4, this.lpszConversationID);
            this.pointer.setIntAt(i += 4, this.flFlags);
            this.pointer.setIntAt(i += 4, this.lpOriginator);
            this.pointer.setIntAt(i += 4, this.nRecipCount.getValue());
            this.pointer.setIntAt(i += 4, this.lpRecips);
            this.pointer.setIntAt(i += 4, this.nFileCount.getValue());
            this.pointer.setIntAt(i += 4, this.lpFiles);
        } else {
            this.pointer = Pointer.createPointer(MapiMessage.sizeOf());
        }
        return this.pointer;
    }

    @Override
    public int getSizeOf() {
        return MapiMessage.sizeOf();
    }

    public static int sizeOf() {
        return 48;
    }
}

