/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11SecretKeyFactory
extends SecretKeyFactorySpi {
    private final Token token;
    private final String algorithm;
    private static final Map<String, Long> keyTypes = new HashMap<String, Long>();

    P11SecretKeyFactory(Token token, String string) {
        this.token = token;
        this.algorithm = string;
    }

    private static void addKeyType(String string, long l) {
        Long l2 = l;
        keyTypes.put(string, l2);
        keyTypes.put(string.toUpperCase(Locale.ENGLISH), l2);
    }

    static long getKeyType(String string) {
        Long l = keyTypes.get(string);
        if (l == null && (l = keyTypes.get(string = string.toUpperCase(Locale.ENGLISH))) == null) {
            if (string.startsWith("HMAC")) {
                return 2147483427L;
            }
            if (string.startsWith("SSLMAC")) {
                return 2147483428L;
            }
        }
        return l != null ? l : -1L;
    }

    static P11Key convertKey(Token token, Key key, String string) throws InvalidKeyException {
        P11Key p11Key;
        long l;
        token.ensureValid();
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key must be a SecretKey");
        }
        if (string == null) {
            string = key.getAlgorithm();
            l = P11SecretKeyFactory.getKeyType(string);
        } else {
            long l2;
            l = P11SecretKeyFactory.getKeyType(string);
            if (l != (l2 = P11SecretKeyFactory.getKeyType(key.getAlgorithm())) && l != 2147483427L && l != 2147483428L) {
                throw new InvalidKeyException("Key algorithm must be " + string);
            }
        }
        if (key instanceof P11Key) {
            P11Key p11Key2 = (P11Key)key;
            if (p11Key2.token == token) {
                return p11Key2;
            }
        }
        if ((p11Key = token.secretCache.get(key)) != null) {
            return p11Key;
        }
        if (!"RAW".equals(key.getFormat())) {
            throw new InvalidKeyException("Encoded format must be RAW");
        }
        byte[] byArray = key.getEncoded();
        p11Key = P11SecretKeyFactory.createKey(token, byArray, string, l);
        token.secretCache.put(key, p11Key);
        return p11Key;
    }

    static void fixDESParity(byte[] byArray, int n) {
        for (int i = 0; i < 8; ++i) {
            int n2 = byArray[n] & 0xFE;
            n2 |= Integer.bitCount(n2) & 1 ^ 1;
            byArray[n++] = (byte)n2;
        }
    }

    private static P11Key createKey(Token token, byte[] byArray, String string, long l) throws InvalidKeyException {
        P11Key p11Key;
        int n;
        int n2 = byArray.length;
        switch ((int)l) {
            case 18: {
                if (n2 < 5 || n2 > 128) {
                    throw new InvalidKeyException("ARCFOUR key length must be between 5 and 128 bytes");
                }
                n = n2 << 3;
                break;
            }
            case 19: {
                if (n2 != 8) {
                    throw new InvalidKeyException("DES key length must be 8 bytes");
                }
                n = 56;
                P11SecretKeyFactory.fixDESParity(byArray, 0);
                break;
            }
            case 21: {
                if (n2 == 16) {
                    l = 20L;
                } else if (n2 == 24) {
                    l = 21L;
                    P11SecretKeyFactory.fixDESParity(byArray, 16);
                } else {
                    throw new InvalidKeyException("DESede key length must be 16 or 24 bytes");
                }
                P11SecretKeyFactory.fixDESParity(byArray, 0);
                P11SecretKeyFactory.fixDESParity(byArray, 8);
                n = n2 * 7;
                break;
            }
            case 31: {
                if (n2 != 16 && n2 != 24 && n2 != 32) {
                    throw new InvalidKeyException("AES key length must be 16, 24, or 32 bytes");
                }
                n = n2 << 3;
                break;
            }
            case 32: {
                if (n2 < 5 || n2 > 56) {
                    throw new InvalidKeyException("Blowfish key length must be between 5 and 56 bytes");
                }
                n = n2 << 3;
                break;
            }
            case 16: 
            case 2147483429: 
            case 2147483430: 
            case 0x7FFFFF27: {
                l = 16L;
                n = n2 << 3;
                break;
            }
            case 2147483427: 
            case 2147483428: {
                if (n2 == 0) {
                    throw new InvalidKeyException("MAC keys must not be empty");
                }
                l = 16L;
                n = n2 << 3;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown algorithm " + string);
            }
        }
        Session session = null;
        try {
            P11Key p11Key2;
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, l), new CK_ATTRIBUTE(17L, byArray)};
            cK_ATTRIBUTEArray = token.getAttributes("import", 4L, l, cK_ATTRIBUTEArray);
            session = token.getObjSession();
            long l2 = token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            p11Key = p11Key2 = (P11Key)((Object)P11Key.secretKey(session, l2, string, n, cK_ATTRIBUTEArray));
            token.releaseSession(session);
        }
        catch (PKCS11Exception pKCS11Exception) {
            try {
                throw new InvalidKeyException("Could not create key", pKCS11Exception);
            }
            catch (Throwable throwable) {
                token.releaseSession(session);
                throw throwable;
            }
        }
        return p11Key;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec == null) {
            throw new InvalidKeySpecException("KeySpec must not be null");
        }
        if (keySpec instanceof SecretKeySpec) {
            try {
                P11Key p11Key = P11SecretKeyFactory.convertKey(this.token, (SecretKey)((Object)keySpec), this.algorithm);
                return (SecretKey)((Object)p11Key);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new InvalidKeySpecException(invalidKeyException);
            }
        }
        if (this.algorithm.equalsIgnoreCase("DES")) {
            if (keySpec instanceof DESKeySpec) {
                byte[] byArray = ((DESKeySpec)keySpec).getKey();
                keySpec = new SecretKeySpec(byArray, "DES");
                return this.engineGenerateSecret(keySpec);
            }
        } else if (this.algorithm.equalsIgnoreCase("DESede") && keySpec instanceof DESedeKeySpec) {
            byte[] byArray = ((DESedeKeySpec)keySpec).getKey();
            keySpec = new SecretKeySpec(byArray, "DESede");
            return this.engineGenerateSecret(keySpec);
        }
        throw new InvalidKeySpecException("Unsupported spec: " + keySpec.getClass().getName());
    }

    private byte[] getKeyBytes(SecretKey secretKey) throws InvalidKeySpecException {
        try {
            secretKey = this.engineTranslateKey(secretKey);
            if (!"RAW".equals(secretKey.getFormat())) {
                throw new InvalidKeySpecException("Could not obtain key bytes");
            }
            byte[] byArray = secretKey.getEncoded();
            return byArray;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        block10: {
            this.token.ensureValid();
            if (secretKey == null || clazz == null) {
                throw new InvalidKeySpecException("key and keySpec must not be null");
            }
            if (SecretKeySpec.class.isAssignableFrom(clazz)) {
                return new SecretKeySpec(this.getKeyBytes(secretKey), this.algorithm);
            }
            if (this.algorithm.equalsIgnoreCase("DES")) {
                try {
                    if (DESKeySpec.class.isAssignableFrom(clazz)) {
                        return new DESKeySpec(this.getKeyBytes(secretKey));
                    }
                    break block10;
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException);
                }
            }
            if (this.algorithm.equalsIgnoreCase("DESede")) {
                try {
                    if (DESedeKeySpec.class.isAssignableFrom(clazz)) {
                        return new DESedeKeySpec(this.getKeyBytes(secretKey));
                    }
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidKeySpecException(invalidKeyException);
                }
            }
        }
        throw new InvalidKeySpecException("Unsupported spec: " + clazz.getName());
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        return (SecretKey)((Object)P11SecretKeyFactory.convertKey(this.token, secretKey, this.algorithm));
    }

    static {
        P11SecretKeyFactory.addKeyType("RC4", 18L);
        P11SecretKeyFactory.addKeyType("ARCFOUR", 18L);
        P11SecretKeyFactory.addKeyType("DES", 19L);
        P11SecretKeyFactory.addKeyType("DESede", 21L);
        P11SecretKeyFactory.addKeyType("AES", 31L);
        P11SecretKeyFactory.addKeyType("Blowfish", 32L);
        P11SecretKeyFactory.addKeyType("RC2", 17L);
        P11SecretKeyFactory.addKeyType("IDEA", 26L);
        P11SecretKeyFactory.addKeyType("TlsPremasterSecret", 2147483429L);
        P11SecretKeyFactory.addKeyType("TlsRsaPremasterSecret", 2147483430L);
        P11SecretKeyFactory.addKeyType("TlsMasterSecret", 0x7FFFFF27L);
        P11SecretKeyFactory.addKeyType("Generic", 16L);
    }
}

