/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.InvalidMarkException;

public abstract class Buffer {
    private int mark = -1;
    private int position = 0;
    private int limit;
    private int capacity;
    long address;

    Buffer(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n4;
        this.limit(n3);
        this.position(n2);
        if (n >= 0) {
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this.mark = n;
        }
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final Buffer position(int n) {
        if (n > this.limit || n < 0) {
            throw new IllegalArgumentException();
        }
        this.position = n;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int n) {
        if (n > this.capacity || n < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = n;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    public final Buffer mark() {
        this.mark = this.position;
        return this;
    }

    public final Buffer reset() {
        int n = this.mark;
        if (n < 0) {
            throw new InvalidMarkException();
        }
        this.position = n;
        return this;
    }

    public final Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    public abstract boolean hasArray();

    public abstract Object array();

    public abstract int arrayOffset();

    public abstract boolean isDirect();

    final int nextGetIndex() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.position++;
    }

    final int nextGetIndex(int n) {
        if (this.limit - this.position < n) {
            throw new BufferUnderflowException();
        }
        int n2 = this.position;
        this.position += n;
        return n2;
    }

    final int nextPutIndex() {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        return this.position++;
    }

    final int nextPutIndex(int n) {
        if (this.limit - this.position < n) {
            throw new BufferOverflowException();
        }
        int n2 = this.position;
        this.position += n;
        return n2;
    }

    final int checkIndex(int n) {
        if (n < 0 || n >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return n;
    }

    final int checkIndex(int n, int n2) {
        if (n < 0 || n2 > this.limit - n) {
            throw new IndexOutOfBoundsException();
        }
        return n;
    }

    final int markValue() {
        return this.mark;
    }

    final void truncate() {
        this.mark = -1;
        this.position = 0;
        this.limit = 0;
        this.capacity = 0;
    }

    static void checkBounds(int n, int n2, int n3) {
        if ((n | n2 | n + n2 | n3 - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

