/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.JavaMembers;
import sun.org.mozilla.javascript.internal.VMBridge;
import sun.reflect.misc.MethodUtil;

final class MemberBox {
    private static final Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private transient Member memberObject;
    transient Class[] argTypes;

    MemberBox(Method method) {
        this.init(method);
    }

    MemberBox(Constructor constructor) {
        this.init(constructor);
    }

    private void init(Method method) {
        this.memberObject = method;
        this.argTypes = method.getParameterTypes();
    }

    private void init(Constructor constructor) {
        this.memberObject = constructor;
        this.argTypes = constructor.getParameterTypes();
    }

    Method method() {
        return (Method)this.memberObject;
    }

    Constructor ctor() {
        return (Constructor)this.memberObject;
    }

    boolean isMethod() {
        return this.memberObject instanceof Method;
    }

    boolean isCtor() {
        return this.memberObject instanceof Constructor;
    }

    boolean isStatic() {
        return Modifier.isStatic(this.memberObject.getModifiers());
    }

    String getName() {
        return this.memberObject.getName();
    }

    Class getDeclaringClass() {
        return this.memberObject.getDeclaringClass();
    }

    String toJavaDeclaration() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isMethod()) {
            Method method = this.method();
            stringBuffer.append(method.getReturnType());
            stringBuffer.append(' ');
            stringBuffer.append(method.getName());
        } else {
            Constructor constructor = this.ctor();
            String string = constructor.getDeclaringClass().getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(JavaMembers.liveConnectSignature(this.argTypes));
        return stringBuffer.toString();
    }

    public String toString() {
        return this.memberObject.toString();
    }

    Object invoke(Object object, Object[] objectArray) {
        Method method = this.method();
        try {
            try {
                return MethodUtil.invoke(method, object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Method method2 = MemberBox.searchAccessibleMethod(method, this.argTypes);
                if (method2 != null) {
                    this.memberObject = method2;
                    method = method2;
                } else if (!VMBridge.instance.tryToMakeAccessible(method)) {
                    throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                }
                return MethodUtil.invoke(method, object, objectArray);
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    Object newInstance(Object[] objectArray) {
        Constructor constructor = this.ctor();
        try {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!VMBridge.instance.tryToMakeAccessible(constructor)) {
                    throw Context.throwAsScriptRuntimeEx(illegalAccessException);
                }
                return constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
    }

    private static Method searchAccessibleMethod(Method method, Class[] classArray) {
        Class<?> clazz;
        int n = method.getModifiers();
        if (Modifier.isPublic(n) && !Modifier.isStatic(n) && !Modifier.isPublic((clazz = method.getDeclaringClass()).getModifiers())) {
            String string = method.getName();
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n2 = classArray2.length;
            for (int i = 0; i != n2; ++i) {
                Class<?> clazz2 = classArray2[i];
                if (!Modifier.isPublic(clazz2.getModifiers())) continue;
                try {
                    return clazz2.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            while ((clazz = clazz.getSuperclass()) != null) {
                if (!Modifier.isPublic(clazz.getModifiers())) continue;
                try {
                    Method method2 = clazz.getMethod(string, classArray);
                    n2 = method2.getModifiers();
                    if (!Modifier.isPublic(n2) || Modifier.isStatic(n2)) continue;
                    return method2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        return null;
    }
}

