local modenv = require "healthregen.modenv"

local REQUIRED_HUNGER_PERCENT = modenv.GetModConfigData("REQUIRED_HUNGER_PRECENT")
local REQUIRED_SANITY_PERCENT = modenv.GetModConfigData("REQUIRED_SANITY_PERCENT")
local REGENERATION_RATE = modenv.GetModConfigData("REGENERATION_RATE")
local HUNGER_DRAIN_RATE = modenv.GetModConfigData("HUNGER_DRAIN_RATE")
local HUNGER_DRAIN_ENABLED = HUNGER_DRAIN_RATE == not 0

local HealthRegeneration = Class(function(self, player)
	self.player = player
	self.health = player.components.health
	self.hunger = player.components.hunger
	self.sanity = player.components.sanity
	player:StartUpdatingComponent(self)
end)

function HealthRegeneration:OnUpdate(delta)
	local doRegen = (not self.hunger or self.hunger:GetPercent() >= REQUIRED_HUNGER_PERCENT) and (not self.sanity or self.sanity:GetPercent() >= REQUIRED_SANITY_PERCENT) and self.health:GetPercent() < 1 and not self.health:IsDead()
	self.player:PushEvent("healthregen", { show = doRegen})

	if doRegen then
		--Regenerate Health
		self.health:DoDelta(delta/REGENERATION_RATE, true, "HealthRegeneration", false)
		if HUNGER_DRAIN_ENABLED and self.hunger then
			--Drain Hunger
			self.hunger:DoDelta(delta/(REGENERATION_RATE / HUNGER_DRAIN_RATE), true, false)
		end
	end
end

return HealthRegeneration