local Widget = require "widgets/widget"
local UIAnim = require "widgets/uianim"

local ArrowWidget = Class(Widget, function(self)
	Widget._ctor(self, "RegenArrow")

	self.arrow = self:AddChild(UIAnim())
	self.arrow:GetAnimState():SetBank("sanity_arrow")
	self.arrow:GetAnimState():SetBuild("sanity_arrow")
	self.arrow:GetAnimState():PlayAnimation("neutral")
	self.arrow:SetClickable(false)
end)

function ArrowWidget:ShowArrow(show)
	local anim = show and "arrow_loop_increase" or "neutral"

   --Switch the animation state if not already set
	if self.old_anim ~= anim then
		self.old_anim = anim
		self.arrow:GetAnimState():PlayAnimation(anim, true)
	end
end

return ArrowWidget