
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/zhaoyun.zip" ),
}
local prefabs = { "Spear" }

local start_inv =
{
	"Spear",
} 

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "willow.png" )

	-- todo: Add an example special power here.
	
	inst.components.builder.bonus_tech_level = 1
	inst.components.sanity.dapperness = TUNING.DAPPERNESS_LARGE
	inst.components.health:StartRegen(10, 60)
	inst.components.hunger:SetMax(500)
	inst.components.health:SetMaxHealth(500)
	inst.components.sanity:SetMax(777)
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 2
	inst.components.combat.damagemultiplier = 2
	inst.components.inventory:GuaranteeItems(start_inv)
	if GetPlayer().prefab ~= "zhaoyun" then
	TUNING.SPEAR_DAMAGE=177
	TUNING.SPEAR_USES=1777
	TUNING.ARMORGRASS = 338
	TUNING.ARMORWOOD = 675
	TUNING.ARMORMARBLE = 1575
	TUNING.ARMOR_FOOTBALLHAT = 675
	TUNING.ARMOR_SLURTLEHAT = 1125
	TUNING.ARMOR_BEEHAT = 1125
	TUNING.ARMOR_SANITY = 1125
	end

end


-- strings! Any "zhaoyun" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.zhaoyun = "սʿ"
STRINGS.CHARACTER_NAMES.zhaoyun = ""
STRINGS.CHARACTER_DESCRIPTIONS.zhaoyun = "* ǿսʿ\n* Լ\n* "
STRINGS.CHARACTER_QUOTES.zhaoyun = "\"Ϊҫ\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.zhaoyun = {}
STRINGS.CHARACTERS.zhaoyun.DESCRIBE = {}
STRINGS.CHARACTERS.zhaoyun.DESCRIBE.EVERGREEN = "Ϊҫ"



return MakePlayerCharacter("zhaoyun", prefabs, assets, fn)
