local function little_stack(inst)
	inst.components.stackable.maxsize = 40
end

local function small_stack(inst)
	inst.components.stackable.maxsize = 30
end

local function med_stack(inst)
	inst.components.stackable.maxsize = 20
end

local function big_stack(inst)
	inst.components.stackable.maxsize = 15
end

local function large_stack(inst)
	inst.components.stackable.maxsize = 10
end

local function stackable(inst)
	inst:AddComponent("stackable")
	if inst.prefab == "snakeoil" then
		inst.components.stackable.maxsize = 40 else
		inst.components.stackable.maxsize = 20
	end

end

local function pigskin(inst)
	inst:RemoveComponent("edible")
end

--------------------food-------------------------
AddPrefabPostInit("pigskin",pigskin)

AddPrefabPostInit("meat", little_stack)
AddPrefabPostInit("cookedmeat", little_stack)
AddPrefabPostInit("meat_dried", little_stack)
AddPrefabPostInit("monstermeat", little_stack)
AddPrefabPostInit("cookedmonstermeat", little_stack)
AddPrefabPostInit("monstermeat_dried", little_stack)
AddPrefabPostInit("plantmeat", little_stack)
AddPrefabPostInit("plantmeat_cooked", little_stack)
AddPrefabPostInit("smallmeat", little_stack)
AddPrefabPostInit("cookedsmallmeat", little_stack)
AddPrefabPostInit("smallmeat_dried", little_stack)
AddPrefabPostInit("drumstick", little_stack)
AddPrefabPostInit("drumstick_cooked", little_stack)
AddPrefabPostInit("fish", little_stack)
AddPrefabPostInit("fish_cooked", little_stack)
AddPrefabPostInit("froglegs", little_stack)
AddPrefabPostInit("froglegs_cooked", little_stack)
AddPrefabPostInit("batwing", little_stack)
AddPrefabPostInit("batwing_cooked", little_stack)
AddPrefabPostInit("trunk_summer", little_stack)
AddPrefabPostInit("trunk_cooked", little_stack)
AddPrefabPostInit("trunk_winter", little_stack)
AddPrefabPostInit("pumpkin", little_stack)
AddPrefabPostInit("eggplant", little_stack)
AddPrefabPostInit("durian", little_stack)
AddPrefabPostInit("honeycomb", little_stack)

--------------------mob-drops-------------------------

AddPrefabPostInit("spidergland", little_stack)
AddPrefabPostInit("goldnugget", little_stack)
AddPrefabPostInit("lureplantbulb", little_stack)
AddPrefabPostInit("poop", little_stack)
AddPrefabPostInit("guano", little_stack)
AddPrefabPostInit("spidereggsack", little_stack)
AddPrefabPostInit("goose_feather", little_stack)
AddPrefabPostInit("deerclops_eyeball", little_stack)
AddPrefabPostInit("lightninggoathorn", little_stack)
AddPrefabPostInit("lureplant_bulb", little_stack)
AddPrefabPostInit("bearger_fur", little_stack)
AddPrefabPostInit("dragon_scales", little_stack)
AddPrefabPostInit("blubber", little_stack)
AddPrefabPostInit("boneshard", little_stack)

AddPrefabPostInit("shark_fin", little_stack)

--------------------mobs-------------------------

AddPrefabPostInit("bee", med_stack)
AddPrefabPostInit("rabbit", stackable)
AddPrefabPostInit("robin", stackable)
AddPrefabPostInit("robin_winter", stackable)
AddPrefabPostInit("crow", stackable)
AddPrefabPostInit("parrot", stackable)
AddPrefabPostInit("seagull", stackable)
AddPrefabPostInit("toucan", stackable)
AddPrefabPostInit("crab", stackable)
AddPrefabPostInit("jellyfish", stackable)
AddPrefabPostInit("rabbit", large_stack)
AddPrefabPostInit("robin", large_stack)
AddPrefabPostInit("robin_winter", large_stack)
AddPrefabPostInit("crow", large_stack)
AddPrefabPostInit("parrot", large_stack)
AddPrefabPostInit("seagull", large_stack)
AddPrefabPostInit("toucan", large_stack)
AddPrefabPostInit("crab", large_stack)
AddPrefabPostInit("jellyfish", large_stack)

--------------------refined-------------------------

AddPrefabPostInit("boards", med_stack)
AddPrefabPostInit("cutstone", med_stack)
AddPrefabPostInit("rope", med_stack)
AddPrefabPostInit("transistor", med_stack)
AddPrefabPostInit("limestone", med_stack)

--------------------misc-------------------------

AddPrefabPostInit("livinglog", small_stack)
AddPrefabPostInit("seashell", little_stack)
AddPrefabPostInit("log", small_stack)
AddPrefabPostInit("blowdart", small_stack)
AddPrefabPostInit("snakeoil", stackable)
AddPrefabPostInit("snakeoil", little_stack)


--------------------turfs-------------------------

AddPrefabPostInit("turf_road", little_stack)
AddPrefabPostInit("turf_rocky", little_stack)
AddPrefabPostInit("turf_forest", little_stack)
AddPrefabPostInit("turf_marsh", little_stack)
AddPrefabPostInit("turf_grass", little_stack)
AddPrefabPostInit("turf_savanna", little_stack)
AddPrefabPostInit("turf_dirt", little_stack)
AddPrefabPostInit("turf_woodfloor", little_stack)
AddPrefabPostInit("turf_carpetfloor", little_stack)
AddPrefabPostInit("turf_checkerfloor", little_stack)
AddPrefabPostInit("turf_cave", little_stack)
AddPrefabPostInit("turf_fungus", little_stack)
AddPrefabPostInit("turf_fungus_red", little_stack)
AddPrefabPostInit("turf_fungus_green", little_stack)
AddPrefabPostInit("turf_sinkhole", little_stack)
AddPrefabPostInit("turf_underrock", little_stack)
AddPrefabPostInit("turf_mud", little_stack)
AddPrefabPostInit("turf_deciduous", little_stack)
AddPrefabPostInit("turf_desertdirt", little_stack)
AddPrefabPostInit("turf_beach", little_stack)
AddPrefabPostInit("turf_jungle", little_stack)
AddPrefabPostInit("turf_swamp", little_stack)
AddPrefabPostInit("turf_volcano", little_stack)
AddPrefabPostInit("turf_ash", little_stack)
AddPrefabPostInit("turf_magmafield", little_stack)
AddPrefabPostInit("turf_tidalmarsh", little_stack)
AddPrefabPostInit("turf_meadow", little_stack)

--------------------dug-------------------------

AddPrefabPostInit("dug_bambootree", med_stack)
AddPrefabPostInit("dug_marsh_bush", med_stack)
AddPrefabPostInit("dug_bush_vine", med_stack)
AddPrefabPostInit("dug_berrybush", med_stack)
AddPrefabPostInit("dug_grass", med_stack)
AddPrefabPostInit("dug_berrybush", med_stack)
AddPrefabPostInit("dug_berrybush2", med_stack)
AddPrefabPostInit("dug_sapling", med_stack)

--[[
local function RoG(inst)
	if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then

	end
end

local function SW(inst)
	if GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) then

	end
end
]]