/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.watch;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.watch.WatchException;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.ArrayUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class WatchServer
extends Thread
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private WatchService watchService;
    protected WatchEvent.Kind<?>[] events;
    private WatchEvent.Modifier[] modifiers;
    protected boolean isClosed;
    private Map<WatchKey, Path> watchKeyPathMap = new HashMap<WatchKey, Path>();

    public void init() throws WatchException {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new WatchException(e);
        }
        this.isClosed = false;
    }

    public void setModifiers(WatchEvent.Modifier[] modifiers) {
        this.modifiers = modifiers;
    }

    public void registerPath(Path path, int maxDepth) {
        block3: {
            try {
                WatchKey key = ArrayUtil.isEmpty(this.modifiers) ? path.register(this.watchService, this.events) : path.register(this.watchService, this.events, this.modifiers);
                this.watchKeyPathMap.put(key, path);
                if (maxDepth > 1) {
                    Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            WatchServer.this.registerPath(dir, 0);
                            return super.postVisitDirectory(dir, exc);
                        }
                    });
                }
            }
            catch (IOException e) {
                if (e instanceof AccessDeniedException) break block3;
                throw new WatchException(e);
            }
        }
    }

    public void watch(Watcher watcher, Filter<WatchEvent<?>> watchFilter) {
        WatchKey wk;
        try {
            wk = this.watchService.take();
        }
        catch (InterruptedException | ClosedWatchServiceException e) {
            return;
        }
        Path currentPath = this.watchKeyPathMap.get(wk);
        for (WatchEvent<?> event : wk.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (null != watchFilter && !watchFilter.accept(event)) continue;
            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                watcher.onCreate(event, currentPath);
                continue;
            }
            if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                watcher.onModify(event, currentPath);
                continue;
            }
            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                watcher.onDelete(event, currentPath);
                continue;
            }
            if (kind != StandardWatchEventKinds.OVERFLOW) continue;
            watcher.onOverflow(event, currentPath);
        }
        wk.reset();
    }

    @Override
    public void close() {
        this.isClosed = true;
        IoUtil.close(this.watchService);
    }
}

